/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class StarsEffect
implements EffectLayer {
    private static final int STARS_CAP = 1;
    private static final long SPAWN_INTERVAL = 3500L;
    private static final int MIN_LIFE = 550;
    private static final int MAX_LIFE = 800;
    private static final float MIN_SIZE = 20.0f;
    private static final float MAX_SIZE = 50.0f;
    private static final float CORE_SIZE = 11.0f;
    private static final float GLOW_SIZE = 2.0f;
    private static final float OFFSET = 0.0f;
    private static final int[] DEFAULT_COLORS = new int[]{-1996488705, -1996488705, -1996488705};
    private static final Deque<Star> stars = new ArrayDeque<Star>();
    private final int[] colors;
    private long lastSpawn = 0L;

    public StarsEffect() {
        this(DEFAULT_COLORS);
    }

    public StarsEffect(int[] colors) {
        this.colors = colors == null || colors.length == 0 ? DEFAULT_COLORS : (int[])colors.clone();
    }

    @Override
    public void render(TooltipContext context, Vec2 position) {
        int positionX = (int)position.x;
        int positionY = (int)position.y;
        int tooltipWidth = (int)context.getTooltipSize().x;
        int tooltipHeight = (int)context.getTooltipSize().y;
        long now = System.currentTimeMillis();
        if (now - this.lastSpawn >= 3500L && stars.size() < 1) {
            this.spawnStar(tooltipWidth, tooltipHeight, now);
            this.lastSpawn = now;
        }
        context.push(() -> {
            context.getGraphics().enableScissor(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f pose = context.getPose().last().pose();
            stars.removeIf(star -> !star.updateAndRender(pose, now, positionX, positionY));
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            context.getGraphics().disableScissor();
        });
    }

    private void spawnStar(int width, int height, long now) {
        Random random = new Random();
        float margin = 10.0f;
        float localX = margin + random.nextFloat() * Math.max(1.0f, (float)width - 2.0f * margin);
        float localY = margin + random.nextFloat() * Math.max(1.0f, (float)height - 2.0f * margin);
        float rot = random.nextFloat() * (float)Math.PI;
        float maxLength = AnimationUtils.lerp(20.0f, 50.0f, random.nextFloat());
        int life = AnimationUtils.randomBetween(random, 550, 800);
        int color = this.colors[random.nextInt(this.colors.length)];
        float coreScale = 0.9f + 0.2f * random.nextFloat();
        float twinklePhase = random.nextFloat() * ((float)Math.PI * 2);
        stars.addLast(new Star(localX, localY, maxLength, now, life, color, rot, coreScale, twinklePhase));
        if (stars.size() > 1) {
            stars.pollFirst();
        }
    }

    private static void draw(Matrix4f pose, float x1, float y1, float x2, float y2, float tStart, float tEnd, int r, int g, int b, int a) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float len = (float)Math.max(0.001, Math.hypot(dx, dy));
        float nx = -dy / len;
        float ny = dx / len;
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buf = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        buf.addVertex(pose, x1 - nx * tStart * 0.5f, y1 - ny * tStart * 0.5f, 0.0f).setColor(r, g, b, a);
        buf.addVertex(pose, x1 + nx * tStart * 0.5f, y1 + ny * tStart * 0.5f, 0.0f).setColor(r, g, b, a);
        buf.addVertex(pose, x2 - nx * tEnd * 0.5f, y2 - ny * tEnd * 0.5f, 0.0f).setColor(r, g, b, a);
        buf.addVertex(pose, x2 + nx * tEnd * 0.5f, y2 + ny * tEnd * 0.5f, 0.0f).setColor(r, g, b, a);
        try (MeshData data = buf.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }

    private record Star(float localX, float localY, float maxLen, long birth, int lifetime, int argb, float baseRot, float coreScale, float twinklePhase) {
        boolean updateAndRender(Matrix4f pose, long now, float nowX, float nowY) {
            float time = (float)(now - this.birth) / (float)this.lifetime;
            if (time >= 1.0f) {
                return false;
            }
            float centerX = nowX + this.localX;
            float centerY = nowY + this.localY;
            float s = (float)Math.sin(Math.PI * (double)AnimationUtils.clamp(time, 0.0f, 1.0f));
            float rot = this.baseRot + (float)Math.sin((float)(now - this.birth) * 0.0023f) * 0.08f;
            float alphaFactor = (float)Math.pow(1.0f - time, 1.15f);
            int red = ColorUtils.red(this.argb);
            int green = ColorUtils.green(this.argb);
            int blue = ColorUtils.blue(this.argb);
            float length = 4.0f + s * this.maxLen;
            float twinkle = 0.85f + 0.15f * (float)Math.sin((float)(now - this.birth) * 0.006f + this.twinklePhase);
            float tCoreBase = 11.0f * this.coreScale * twinkle;
            float tInner = 0.8f + 0.4f * (1.0f - s);
            for (int i = 0; i < 4; ++i) {
                float angle = rot + (float)i * 1.5707964f;
                float ax = (float)Math.cos(angle);
                float ay = (float)Math.sin(angle);
                float x2 = centerX + ax * length;
                float y2 = centerY + ay * length;
                float haloStart = tCoreBase * 2.0f * 0.7f;
                float haloEnd = tInner * 2.0f * 0.7f;
                StarsEffect.draw(pose, centerX, centerY, x2, y2, haloStart, haloEnd, red, green, blue, (int)(90.0f * alphaFactor));
                float coreStart = tCoreBase * 0.7f;
                float coreEnd = tInner * 0.9f;
                StarsEffect.draw(pose, centerX, centerY, x2, y2, coreStart, coreEnd, red, green, blue, (int)(200.0f * alphaFactor));
                float nx = -ay * 0.0f;
                float ny = ax * 0.0f;
                float borderStart = tCoreBase * 0.6f;
                float borderEnd = tInner * 0.8f;
                StarsEffect.draw(pose, centerX + nx, centerY + ny, x2 + nx, y2 + ny, borderStart, borderEnd, 255, 80, 80, (int)(110.0f * alphaFactor));
                StarsEffect.draw(pose, centerX - nx, centerY - ny, x2 - nx, y2 - ny, borderStart, borderEnd, 80, 120, 255, (int)(110.0f * alphaFactor));
            }
            return true;
        }
    }
}

