/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class TimeSpiralEffect
implements EffectLayer {
    private static final int HALO_COLOR_CORE = 900234495;
    private static final int HALO_COLOR_EDGE = -5735169;
    private static final int RING_COLOR = -1868006145;
    private static final int RING_GLOW_COLOR = 1084783871;
    private static final int SPIRAL_COLOR_NEAR = -1597444097;
    private static final int SPIRAL_COLOR_FAR = 815849727;
    private static final int ARM_COUNT = 4;
    private static final int SEGMENTS = 96;

    @Override
    public void render(TooltipContext context, Vec2 position) {
        int positionX = (int)position.x;
        int positionY = (int)position.y;
        int tooltipWidth = (int)context.getTooltipSize().x;
        int tooltipHeight = (int)context.getTooltipSize().y;
        long now = System.currentTimeMillis();
        float time = (float)(now % context.getStartTime()) / 5000.0f;
        float globalAngle = time * ((float)Math.PI * 2);
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeight * 0.5f;
        float maxRadius = (float)(Math.hypot(tooltipWidth, tooltipHeight) * 0.75);
        float baseThickness = Math.max(3.5f, maxRadius * 0.08f);
        context.push(() -> {
            context.getGraphics().enableScissor(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            context.translate(0.0f, 0.0f, context.getLayerDepth().getZ());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f pose = context.getPose().last().pose();
            Tesselator tess = Tesselator.getInstance();
            this.renderRadialHalo(tess, pose, centerX, centerY, maxRadius, tooltipWidth, tooltipHeight, time);
            this.renderOrbitRings(tess, pose, centerX, centerY, maxRadius, time, globalAngle);
            this.renderSpiralArms(tess, pose, centerX, centerY, maxRadius, baseThickness, time, globalAngle);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            context.getGraphics().disableScissor();
        });
    }

    private void renderRadialHalo(Tesselator tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, int width, int height, float time) {
        float aspect = (float)height / (float)width;
        float pulse = 1.13f + 0.06f * (float)Math.sin((double)time * Math.PI * 2.0 * (double)1.6f);
        float outerRadius = maxRadius * 0.95f * pulse;
        float innerRadius = outerRadius * 0.65f;
        float centerRadius = innerRadius * 0.3f;
        int coreRed = ColorUtils.red(900234495);
        int coreGreen = ColorUtils.green(900234495);
        int coreBlue = ColorUtils.blue(900234495);
        int coreAlpha = ColorUtils.alpha(900234495);
        int edgeRed = ColorUtils.red(-5735169);
        int edgeGreen = ColorUtils.green(-5735169);
        int edgeBlue = ColorUtils.blue(-5735169);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        for (int i = 0; i <= 96; ++i) {
            float s = (float)i / 96.0f;
            float angle = s * ((float)Math.PI * 2);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float sx = cos;
            float sy = sin * aspect;
            float ix = centerX + sx * innerRadius;
            float iy = centerY + sy * innerRadius;
            float ox = centerX + sx * outerRadius;
            float oy = centerY + sy * outerRadius;
            float ringT = 1.0f - (float)Math.abs(Math.sin(angle * 0.5f));
            float alphaFactorInner = 0.75f + 0.25f * ringT;
            int innerA = AnimationUtils.clamp255((int)((float)coreAlpha * alphaFactorInner));
            bufferBuilder.addVertex(pose, ox, oy, 0.0f).setColor(edgeRed, edgeGreen, edgeBlue, 180);
            bufferBuilder.addVertex(pose, ix, iy, 0.0f).setColor(coreRed, coreGreen, coreBlue, innerA);
        }
        try (MeshData data = bufferBuilder.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
        BufferBuilder bufferBuilder2 = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        for (int i = 0; i <= 96; ++i) {
            float s = (float)i / 96.0f;
            float angle = s * ((float)Math.PI * 2);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float sx = cos;
            float sy = sin * aspect;
            float cx_pos = centerX + sx * centerRadius;
            float cy_pos = centerY + sy * centerRadius;
            float ix = centerX + sx * innerRadius;
            float iy = centerY + sy * innerRadius;
            float ringT = 1.0f - (float)Math.abs(Math.sin(angle * 0.5f));
            float alphaFactorInner = 0.75f + 0.25f * ringT;
            int innerA = AnimationUtils.clamp255((int)((float)coreAlpha * alphaFactorInner));
            bufferBuilder2.addVertex(pose, ix, iy, 0.0f).setColor(coreRed, coreGreen, coreBlue, innerA);
            bufferBuilder2.addVertex(pose, cx_pos, cy_pos, 0.0f).setColor(coreRed, coreGreen, coreBlue, 0);
        }
        try (MeshData data = bufferBuilder2.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }

    private void renderOrbitRings(Tesselator tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time, float globalAngle) {
        float baseRadius = maxRadius * 0.55f;
        int ringRed = ColorUtils.red(-1868006145);
        int ringGreen = ColorUtils.green(-1868006145);
        int ringBlue = ColorUtils.blue(-1868006145);
        int ringAlpha = ColorUtils.alpha(-1868006145);
        int glowRed = ColorUtils.red(1084783871);
        int glowGreen = ColorUtils.green(1084783871);
        int glowBlue = ColorUtils.blue(1084783871);
        int glowAlpha = ColorUtils.alpha(1084783871);
        for (int ringIndex = 0; ringIndex < 2; ++ringIndex) {
            float offset = ringIndex == 0 ? -1.0f : 1.0f;
            float radius = baseRadius * (1.0f + 0.12f * offset);
            float ringPhase = globalAngle * (ringIndex == 0 ? 1.1f : -0.9f);
            float thickness = maxRadius * 0.06f;
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            for (int i = 0; i <= 96; ++i) {
                float s = (float)i / 96.0f;
                float angle = s * ((float)Math.PI * 2) + ringPhase;
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float pulse = 0.6f + 0.4f * (float)Math.sin((double)((s * 3.0f + time * 4.0f + (float)ringIndex * 1.7f) * (float)Math.PI) * 2.0);
                float localThickness = thickness * pulse;
                float innerRadius = radius - localThickness * 0.5f;
                float outerRadius = radius + localThickness * 0.5f;
                float ix = centerX + cos * innerRadius;
                float iy = centerY + sin * innerRadius;
                float ox = centerX + cos * outerRadius;
                float oy = centerY + sin * outerRadius;
                float glowMask = 0.5f + 0.5f * (float)Math.cos((double)((s + time) * (float)Math.PI) * 4.0);
                float alphaCore = 0.65f * glowMask;
                float alphaGlow = 0.3f * glowMask;
                int coreAlpha = AnimationUtils.clamp255((int)((float)ringAlpha * alphaCore));
                int haloAlpha = AnimationUtils.clamp255((int)((float)glowAlpha * alphaGlow));
                bufferBuilder.addVertex(pose, ox, oy, 0.0f).setColor(glowRed, glowGreen, glowBlue, haloAlpha);
                bufferBuilder.addVertex(pose, ix, iy, 0.0f).setColor(ringRed, ringGreen, ringBlue, coreAlpha);
            }
            try (MeshData data = bufferBuilder.buildOrThrow();){
                BufferUploader.drawWithShader((MeshData)data);
                continue;
            }
        }
    }

    private void renderSpiralArms(Tesselator tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float baseThickness, float time, float globalAngle) {
        for (int arm = 0; arm < 4; ++arm) {
            float armOffset = 1.5707964f * (float)arm;
            float startAngle = globalAngle + armOffset;
            float endAngle = startAngle + 5.969026f;
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            for (int i = 0; i <= 96; ++i) {
                float eased;
                float s = (float)i / 96.0f;
                float spiralT = eased = AnimationUtils.smoothstep(0.0f, 1.0f, s);
                float radius = (float)Math.pow(spiralT, 0.9f) * maxRadius;
                float thicknessPulse = 0.65f + 0.35f * (float)Math.sin((double)(time + (float)arm * 0.33f + s * 1.4f) * Math.PI * 2.0);
                float thickness = baseThickness * thicknessPulse * (1.05f - spiralT * 0.75f);
                float wobble = 0.12f * (float)Math.sin((double)(s * 10.0f + (float)arm * 2.5f) + (double)time * Math.PI * 4.0);
                float angle = AnimationUtils.lerp(startAngle, endAngle, s) + wobble;
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float innerRadius = radius - thickness * 0.5f;
                float outerRadius = radius + thickness * 0.5f;
                float innerX = centerX + cos * innerRadius;
                float innerY = centerY + sin * innerRadius;
                float outerX = centerX + cos * outerRadius;
                float outerY = centerY + sin * outerRadius;
                int segmentColor = ColorUtils.lerpColor(-1597444097, 815849727, spiralT);
                int segR = ColorUtils.red(segmentColor);
                int segG = ColorUtils.green(segmentColor);
                int segB = ColorUtils.blue(segmentColor);
                int segA = ColorUtils.alpha(segmentColor);
                float headGlow = (float)Math.pow(1.0f - spiralT, 1.6f);
                float sparkle = 0.6f + 0.4f * (float)Math.sin((double)((time * 1.7f + s * 1.3f + (float)arm * 0.5f) * (float)Math.PI) * 2.0);
                float alphaFactor = AnimationUtils.clamp01(headGlow * (0.55f + 0.45f * sparkle));
                float edgeFade = AnimationUtils.clamp01((spiralT - 0.05f) / 0.9f);
                int innerAlpha = AnimationUtils.clamp255((int)((float)segA * (alphaFactor *= edgeFade)));
                int outerAlpha = AnimationUtils.clamp255((int)((float)segA * alphaFactor * 0.7f));
                bufferBuilder.addVertex(pose, outerX, outerY, 0.0f).setColor(segR, segG, segB, outerAlpha);
                bufferBuilder.addVertex(pose, innerX, innerY, 0.0f).setColor(segR, segG, segB, innerAlpha);
            }
            try (MeshData data = bufferBuilder.buildOrThrow();){
                BufferUploader.drawWithShader((MeshData)data);
                continue;
            }
        }
    }
}

