/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.overlay;

import com.mojang.blaze3d.platform.NativeImage;
import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.layer.impl.OverlayLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.Constants;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.phys.Vec2;

public class DefaultOverlay
implements OverlayLayer {
    private static final int BLOCK_DIMENSION = 44;
    private static final Map<ResourceLocation, TextureMetadata> TEXTURES = new ConcurrentHashMap<ResourceLocation, TextureMetadata>();

    @Override
    public void render(TooltipContext context, Vec2 position) {
        String rawTexturePath = RenderUtils.getOverlayLocation(context);
        if (rawTexturePath == null || rawTexturePath.isBlank() || rawTexturePath.isEmpty()) {
            return;
        }
        ResourceLocation textureLocation = TooltipOverhaul.rawPathOf(rawTexturePath);
        TextureMetadata textureMetadata = DefaultOverlay.getTextureMetadata(textureLocation);
        int textureWidth = textureMetadata.width();
        int textureHeight = textureMetadata.height();
        int frameAmount = textureMetadata.frames();
        int idx = frameAmount > 1 ? (int)(System.currentTimeMillis() / (long)Constants.getOverlayFrameTime() % (long)frameAmount) : 0;
        int frameOffset = idx * Constants.getOverlayFrameDimension();
        int x = (int)position.x;
        int y = (int)position.y;
        int width = (int)context.getTooltipSize().x;
        int height = (int)context.getTooltipSize().y;
        int baseOffset = -25;
        int leftX = x + baseOffset;
        int rightX = x + width - 20;
        int topY = y + baseOffset + 1;
        int bottomY = y + height - 20;
        int centerX = leftX + width / 2 + 2;
        int centerY = topY + height / 2 + 3;
        context.getGraphics().blit(textureLocation, leftX, topY, 0.0f, (float)frameOffset, 44, 44, textureWidth, textureHeight);
        context.getGraphics().blit(textureLocation, rightX, topY, 88.0f, (float)frameOffset, 44, 44, textureWidth, textureHeight);
        context.getGraphics().blit(textureLocation, leftX, bottomY, 0.0f, (float)(88 + frameOffset), 44, 44, textureWidth, textureHeight);
        context.getGraphics().blit(textureLocation, rightX, bottomY, 88.0f, (float)(88 + frameOffset), 44, 44, textureWidth, textureHeight);
        context.getGraphics().blit(textureLocation, leftX, centerY, 0.0f, (float)(44 + frameOffset), 44, 44, textureWidth, textureHeight);
        context.getGraphics().blit(textureLocation, rightX, centerY, 88.0f, (float)(44 + frameOffset), 44, 44, textureWidth, textureHeight);
        context.getGraphics().blit(textureLocation, centerX, topY, 44.0f, (float)frameOffset, 44, 44, textureWidth, textureHeight);
        context.getGraphics().blit(textureLocation, centerX, bottomY, 44.0f, (float)(88 + frameOffset), 44, 44, textureWidth, textureHeight);
    }

    private static TextureMetadata getTextureMetadata(ResourceLocation texture) {
        int frameDimension = Constants.getOverlayFrameDimension();
        return TEXTURES.computeIfAbsent(texture, tex -> {
            try {
                Optional resource = Minecraft.getInstance().getResourceManager().getResource(tex);
                if (resource.isEmpty()) {
                    return new TextureMetadata(frameDimension, frameDimension, 1);
                }
                try (InputStream inputStream = ((Resource)resource.get()).open();){
                    TextureMetadata textureMetadata;
                    block17: {
                        NativeImage img = NativeImage.read((InputStream)inputStream);
                        try {
                            int width = img.getWidth();
                            int heigth = img.getHeight();
                            if (width < frameDimension) {
                                TooltipOverhaul.LOGGER.warn("Texture width {} is smaller than expected {} for {}", new Object[]{width, frameDimension, tex});
                            }
                            if (heigth % frameDimension != 0) {
                                TooltipOverhaul.LOGGER.warn("Texture height {} is not a multiple of {} for {} (animation may look off)", new Object[]{heigth, frameDimension, tex});
                            }
                            textureMetadata = new TextureMetadata(width, heigth, Math.max(1, heigth / frameDimension));
                            if (img == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (img != null) {
                                try {
                                    img.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        img.close();
                    }
                    return textureMetadata;
                }
            }
            catch (Exception exception) {
                TooltipOverhaul.LOGGER.error("Failed to read texture {}: {}", tex, (Object)exception.toString());
                return new TextureMetadata(frameDimension, frameDimension, 1);
            }
        });
    }

    private record TextureMetadata(int width, int height, int frames) {
    }
}

