/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.vignette;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.layer.impl.VignetteLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.style.vignette.parser.VignetteEntry;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import dev.xylonity.tooltipoverhaul.client.util.PositionUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class CircularVignette
implements VignetteLayer {
    private static final int SEGMENTS = 64;
    private final VignetteEntry vignetteEntry;

    public CircularVignette(VignetteEntry vignetteEntry) {
        this.vignetteEntry = vignetteEntry;
    }

    @Override
    public void render(TooltipContext context, Vec2 position) {
        int positionX = (int)position.x;
        int positionY = (int)position.y;
        int tooltipWidth = (int)context.getTooltipSize().x;
        int tooltipHeight = (int)context.getTooltipSize().y;
        int paddingX = context.getPaddingX();
        int paddingY = context.getPaddingY();
        float anchorPositionX = (float)(positionX + PositionUtils.getVignettePosition(context, this.vignetteEntry, TextAxis.X)) + (float)tooltipHeight * ((float)this.vignetteEntry.extraPositionX() / 100.0f);
        float anchorPositionY = (float)(positionY + PositionUtils.getVignettePosition(context, this.vignetteEntry, TextAxis.Y)) + (float)tooltipWidth * ((float)this.vignetteEntry.extraPositionY() / 100.0f);
        float radius = (float)tooltipWidth * this.vignetteEntry.radius();
        int color = this.vignetteEntry.color();
        context.translate(anchorPositionX, anchorPositionY, 0.0f);
        context.getGraphics().enableScissor(positionX - paddingX - 1, positionY - paddingY, positionX + tooltipWidth + paddingX, positionY + tooltipHeight + paddingY);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f pose = context.getPose().last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), ColorUtils.alpha(color));
        for (int i = 0; i <= 64; ++i) {
            float angle = (float)i / 64.0f * (float)Math.PI * 2.0f;
            float vertexPositionX = (float)Math.cos(angle) * radius;
            float vertexPositionY = (float)Math.sin(angle) * radius;
            buffer.addVertex(pose, vertexPositionX, vertexPositionY, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), 0);
        }
        try (MeshData data = buffer.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        context.getGraphics().disableScissor();
    }
}

