/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.storage;

import com.buuz135.transfer_labels.storage.LabelBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class LabelStorage
extends SavedData {
    public static final String DATA_NAME = "TRANSFER_LABELS_LABEL_STORAGE";
    private HashMap<BlockPos, LabelBlock> labelBlocks;
    private final Level level;

    public static LabelStorage getStorageFor(ServerLevel level) {
        return (LabelStorage)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new LabelStorage((Level)level), (compoundTag, provider) -> LabelStorage.createFromCompound((Level)level, compoundTag, provider)), DATA_NAME);
    }

    private static LabelStorage createFromCompound(Level level, CompoundTag compoundTag, HolderLookup.Provider provider) {
        LabelStorage storage = new LabelStorage(level);
        storage.load(compoundTag, provider);
        return storage;
    }

    public static List<LabelBlock> getNearbyLabels(ServerLevel level, BlockPos pos, int distance) {
        return LabelStorage.getStorageFor(level).getLabelBlocks().stream().filter(labelBlock -> labelBlock.getPos().distSqr((Vec3i)pos) <= (double)distance).collect(Collectors.toList());
    }

    public static void addLabel(ServerLevel level, BlockPos blockPos, Direction direction, ItemStack label) {
        LabelStorage.getStorageFor((ServerLevel)level).labelBlocks.computeIfAbsent(blockPos, labelBlock -> new LabelBlock(blockPos, (Level)level)).setLabel(direction, label);
        LabelStorage.getStorageFor(level).setDirty();
    }

    public static void removeLabel(Player player, ServerLevel level, BlockPos blockPos, Direction direction) {
        LabelBlock labelBlock = LabelStorage.getStorageFor((ServerLevel)level).labelBlocks.computeIfAbsent(blockPos, pos -> new LabelBlock(blockPos, (Level)level));
        labelBlock.remove(player, direction);
        if (labelBlock.getLabels().isEmpty()) {
            LabelStorage.getStorageFor((ServerLevel)level).labelBlocks.remove(blockPos);
        }
        LabelStorage.getStorageFor(level).setDirty();
    }

    public List<LabelBlock> getLabelBlocks() {
        return this.labelBlocks.values().stream().collect(Collectors.toList());
    }

    public HashMap<BlockPos, LabelBlock> getLabelBlocksMap() {
        return this.labelBlocks;
    }

    public LabelStorage(Level level) {
        this.level = level;
        this.labelBlocks = new HashMap();
    }

    public void markDirty() {
        this.setDirty();
    }

    public CompoundTag saveNearby(BlockPos pos, int distance, HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.getLabelBlocks().stream().filter(labelBlock -> labelBlock.getPos().distSqr((Vec3i)pos) <= (double)distance).forEach(labelBlock -> compoundTag.put("" + labelBlock.getPos().asLong(), (Tag)labelBlock.serializeNBT(provider)));
        return compoundTag;
    }

    public void loadNearby(BlockPos anchor, int distance, CompoundTag compoundTag, HolderLookup.Provider provider) {
        List<LabelBlock> nearby = this.getLabelBlocks().stream().filter(labelBlock -> labelBlock.getPos().distSqr((Vec3i)anchor) <= (double)distance).toList();
        ArrayList visitedPositions = new ArrayList();
        compoundTag.getAllKeys().forEach(s -> {
            BlockPos pos = BlockPos.of((long)Long.parseLong(s));
            visitedPositions.add(pos);
            if (this.labelBlocks.containsKey(pos)) {
                this.labelBlocks.get(pos).deserializeNBT(provider, compoundTag.getCompound(s));
            } else {
                LabelBlock label = new LabelBlock(pos, this.level);
                label.deserializeNBT(provider, compoundTag.getCompound(s));
                this.labelBlocks.put(pos, label);
            }
        });
        nearby.forEach(labelBlock -> {
            if (!visitedPositions.contains(labelBlock.getPos())) {
                this.labelBlocks.remove(labelBlock.getPos());
            }
        });
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag labels = new CompoundTag();
        this.labelBlocks.forEach((pos, labelBlock) -> labels.put("" + pos.asLong(), (Tag)labelBlock.serializeNBT(provider)));
        compoundTag.put("Labels", (Tag)labels);
        return compoundTag;
    }

    public void load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag labels = compoundTag.getCompound("Labels");
        ArrayList visitedPositions = new ArrayList();
        labels.getAllKeys().forEach(s -> {
            BlockPos pos = BlockPos.of((long)Long.parseLong(s));
            visitedPositions.add(pos);
            if (this.labelBlocks.containsKey(pos)) {
                this.labelBlocks.get(pos).deserializeNBT(provider, labels.getCompound(s));
            } else {
                LabelBlock label = new LabelBlock(pos, this.level);
                label.deserializeNBT(provider, labels.getCompound(s));
                this.labelBlocks.put(pos, label);
            }
        });
        this.labelBlocks.keySet().removeIf(pos -> !visitedPositions.contains(pos));
    }

    public Level getLevel() {
        return this.level;
    }
}

