/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractParticleSpawnerBlock
extends Block {
    public static final IntegerProperty RADIUS = IntegerProperty.create((String)"particle_radius", (int)1, (int)10);

    public AbstractParticleSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)RADIUS, (Comparable)Integer.valueOf(1)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int radius = (Integer)state.getValue((Property)RADIUS);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int partCount = 0; partCount < this.getParticleCountPerSpawn(state); ++partCount) {
            mutablePos.set(x + Mth.nextInt((RandomSource)random, (int)(-radius), (int)radius), y + Mth.nextInt((RandomSource)random, (int)(-radius), (int)radius), z + Mth.nextInt((RandomSource)random, (int)(-radius), (int)radius));
            BlockState offState = level.getBlockState((BlockPos)mutablePos);
            if (offState.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)mutablePos)) continue;
            level.addParticle(this.getParticlesToSpawn(), (double)mutablePos.getX() + random.nextDouble(), (double)mutablePos.getY() + random.nextDouble(), (double)mutablePos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public abstract ParticleOptions getParticlesToSpawn();

    public abstract int getParticleCountPerSpawn(BlockState var1);

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RADIUS});
    }
}

