/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.entity.DryingRackBlockEntity;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;

public class DryingRackBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<DryingRackBlock> CODEC = DryingRackBlock.simpleCodec(DryingRackBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (Object)Direction.WEST, (Object)Block.box((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));

    public DryingRackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ItemInteractionResult useItemOn(ItemStack playerStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DryingRackBlockEntity)) {
            return super.useItemOn(playerStack, state, level, pos, player, hand, hitResult);
        }
        DryingRackBlockEntity rack = (DryingRackBlockEntity)blockEntity;
        if (rack.getTheItem().isEmpty() && !playerStack.isEmpty()) {
            rack.setTheItem(player.hasInfiniteMaterials() ? playerStack.copyWithCount(1) : playerStack.split(1));
            if (level.isClientSide()) return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            level.playSound(null, pos, (SoundEvent)TFSounds.DRYING_RACK_ADD_ITEM.get(), SoundSource.BLOCKS, 1.0f, 0.75f + level.random.nextFloat() * 0.5f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        } else if (!level.isClientSide()) {
            ItemStack item = rack.takeTheItem();
            if (item.isEmpty()) return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            if (!player.getInventory().add(item)) {
                player.drop(item, false);
            }
            level.playSound(null, pos, (SoundEvent)TFSounds.DRYING_RACK_REMOVE_ITEM.get(), SoundSource.BLOCKS, 0.75f, 0.75f + level.random.nextFloat() * 0.5f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        } else {
            if (!rack.getTheItem().isEmpty()) return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, facingState, accessor, currentPos, facingPos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        DryingRackBlockEntity rack;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DryingRackBlockEntity && (rack = (DryingRackBlockEntity)blockEntity).isDrying() && random.nextInt(5) == 0) {
            Direction dir = (Direction)state.getValue((Property)FACING);
            ParticleUtils.spawnParticleOnFace((Level)level, (BlockPos)pos, (Direction)dir, (ParticleOptions)((ParticleOptions)TFParticleType.DRYING_RACK.get()), (Vec3)Vec3.ZERO, (double)0.3f);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DryingRackBlockEntity) {
            DryingRackBlockEntity blockEntity2 = (DryingRackBlockEntity)blockEntity;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)blockEntity2.takeTheItem());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DryingRackBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return DryingRackBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)TFBlockEntities.DRYING_RACK.get()), DryingRackBlockEntity::tick);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }
}

