/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.entity.ReactorDebrisBlockEntity;
import twilightforest.init.TFBlockEntities;

public class ReactorDebrisBlock
extends BaseEntityBlock {
    public VoxelShape SHAPE = Shapes.empty();
    public static final MapCodec<ReactorDebrisBlock> CODEC = ReactorDebrisBlock.simpleCodec(ReactorDebrisBlock::new);

    public ReactorDebrisBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReactorDebrisBlockEntity) {
            ReactorDebrisBlockEntity reactorDebrisBlockEntity = (ReactorDebrisBlockEntity)blockEntity;
            return reactorDebrisBlockEntity.shape;
        }
        return ReactorDebrisBlockEntity.calculateVoxelShape();
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof ReactorDebrisBlockEntity) {
            ReactorDebrisBlockEntity blockEntity2 = (ReactorDebrisBlockEntity)blockEntity;
            blockEntity2.randomizeDimensions();
            blockEntity2.randomizeTextures();
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.is((Block)this)) {
            level.destroyBlock(pos, false);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ReactorDebrisBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.REACTOR_DEBRIS.get()), ReactorDebrisBlockEntity::tick);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ReactorDebrisBlockEntity(blockPos, blockState);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }
}

