/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.AbstractTrophyBlock;
import twilightforest.enums.BossVariant;

public class TrophyBlock
extends AbstractTrophyBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final MapCodec<TrophyBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BossVariant.CODEC.fieldOf("variant").forGetter(AbstractTrophyBlock::getVariant), (App)Codec.INT.fieldOf("pedestal_comparator_strength").forGetter(AbstractTrophyBlock::getComparatorValue), (App)TrophyBlock.propertiesCodec()).apply((Applicative)instance, TrophyBlock::new));
    public static final VoxelShape GHAST_SHAPE = Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    protected static final VoxelShape YETI_X_SHAPE = Block.box((double)3.25, (double)0.0, (double)4.5, (double)12.75, (double)10.0, (double)11.5);
    protected static final VoxelShape YETI_Z_SHAPE = Block.box((double)4.5, (double)0.0, (double)3.25, (double)11.5, (double)10.0, (double)12.75);
    protected static final VoxelShape YETI_CORNER_SHAPE = Block.box((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)10.0, (double)11.5);

    public TrophyBlock(BossVariant variant, int value, BlockBehaviour.Properties properties) {
        super(variant, value, properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((AbstractTrophyBlock)state.getBlock()).getVariant() == BossVariant.UR_GHAST) {
            return GHAST_SHAPE;
        }
        if (((AbstractTrophyBlock)state.getBlock()).getVariant() == BossVariant.ALPHA_YETI) {
            return switch ((Integer)state.getValue((Property)ROTATION)) {
                case 3, 4, 5, 11, 12, 13 -> YETI_Z_SHAPE;
                case 2, 6, 10, 14 -> YETI_CORNER_SHAPE;
                default -> YETI_X_SHAPE;
            };
        }
        return SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.empty();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(Mth.floor((double)((double)(context.getRotation() * 16.0f / 360.0f) + 0.5)) & 0xF));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rot.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION, POWERED});
    }
}

