/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import twilightforest.block.entity.JarBlockEntity;
import twilightforest.init.TFBlockEntities;
import twilightforest.network.SetMasonJarItemPacket;

public class MasonJarBlockEntity
extends JarBlockEntity {
    public static final String TAG_ITEM = "item";
    public static final String TAG_ANGLE = "rotation";
    protected final MasonJarItemStackHandler item = new MasonJarItemStackHandler(this);
    protected int itemRotation = 0;

    public MasonJarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.MASON_JAR.get(), pos, state);
    }

    public MasonJarItemStackHandler getItemHandler() {
        return this.item;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(TAG_ITEM, (Tag)this.item.serializeNBT(registries));
        tag.putInt(TAG_ANGLE, this.itemRotation);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.item.deserializeNBT(registries, tag.getCompound(TAG_ITEM));
        this.itemRotation = tag.getInt(TAG_ANGLE);
    }

    public boolean fillFromLootTable(ResourceKey<LootTable> lootTableKey, long seed, ServerLevel level) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        return this.fillFromLootTable(lootTableKey, seed, level, currentServer.reloadableRegistries());
    }

    public boolean fillFromLootTable(ResourceKey<LootTable> lootTableKey, long seed, ServerLevel serverLevel, ReloadableServerRegistries.Holder holder) {
        LootTable lootTable = holder.getLootTable(lootTableKey);
        if (lootTable == LootTable.EMPTY) {
            return false;
        }
        LootParams params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.getBlockPos())).create(LootContextParamSets.CHEST);
        lootTable.getRandomItemsRaw(new LootContext.Builder(params).withOptionalRandomSeed(seed).create(Optional.of(lootTableKey.location())), this::acceptLootTable);
        return true;
    }

    private void acceptLootTable(ItemStack stack) {
        MasonJarItemStackHandler jarInv = this.getItemHandler();
        if (jarInv.isEmpty()) {
            jarInv.setItem(stack);
        } else {
            ItemStack contained = jarInv.peekItem();
            if (ItemStack.isSameItemSameComponents((ItemStack)contained, (ItemStack)stack)) {
                contained.setCount(Math.min(contained.getCount() + stack.getCount(), contained.getMaxStackSize()));
            }
        }
    }

    public void setFromItem(ItemStack stack) {
        this.applyComponentsFromItemStack(stack);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(List.of(this.item.getItem())));
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.item.setItem(((ItemContainerContents)input.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyOne());
    }

    @Override
    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove(TAG_ITEM);
    }

    public void setChanged() {
        Level level;
        super.setChanged();
        if (this.level != null) {
            BlockPos pos = this.getBlockPos();
            AuxiliaryLightManager lightManager = this.level.getAuxLightManager(pos);
            if (lightManager != null) {
                int n;
                Item item = this.item.getItem().getItem();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    n = blockItem.getBlock().defaultBlockState().getLightEmission();
                } else {
                    n = 0;
                }
                lightManager.setLightAt(pos, n);
            }
            this.level.getLightEngine().checkBlock(pos);
        }
        if ((level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SetMasonJarItemPacket(this.getBlockPos(), this.item.getItem(), this.itemRotation), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public int getItemRotation() {
        return this.itemRotation;
    }

    public void setItemRotation(int itemRotation) {
        this.itemRotation = itemRotation;
    }

    public static class MasonJarItemStackHandler
    extends ItemStackHandler {
        protected final MasonJarBlockEntity jarEntity;

        public MasonJarItemStackHandler(MasonJarBlockEntity jarEntity) {
            super(1);
            this.jarEntity = jarEntity;
        }

        public ItemStack getItem() {
            return ((ItemStack)this.stacks.getFirst()).copy();
        }

        private ItemStack peekItem() {
            return (ItemStack)this.stacks.getFirst();
        }

        public void setItem(ItemStack itemStack) {
            this.stacks.set(0, (Object)itemStack);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.canFitInsideContainerItems();
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (simulate) {
                return super.extractItem(slot, amount, true);
            }
            ItemStack extractedStack = super.extractItem(slot, amount, false);
            if (!extractedStack.isEmpty()) {
                this.jarEntity.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
                this.jarEntity.setChanged();
            }
            return extractedStack;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack returned;
            if (simulate) {
                return super.insertItem(slot, stack, true);
            }
            ItemStack inserted = stack.copy();
            if (!ItemStack.isSameItemSameComponents((ItemStack)inserted, (ItemStack)(returned = super.insertItem(slot, stack, false))) || inserted.getCount() != returned.getCount()) {
                this.jarEntity.wobble(DecoratedPotBlockEntity.WobbleStyle.POSITIVE);
                this.jarEntity.setChanged();
            }
            return returned;
        }

        public boolean isEmpty() {
            return ((ItemStack)this.stacks.getFirst()).isEmpty();
        }
    }
}

