/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.event;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import twilightforest.block.ClimbableHollowLogBlock;
import twilightforest.components.item.PotionFlaskComponent;
import twilightforest.enums.HollowLogVariants;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.util.ColorUtil;
import twilightforest.util.SimplexNoiseHelper;

public class ColorHandler {
    public static final Int2IntFunction CANOPY_COLORIZER = color -> 0xFF000000 | ((color & 0xFEFEFE) + 4627046) / 2;
    public static final Int2IntFunction MANGROVE_COLORIZER = color -> 0xFF000000 | ((color & 0xFEFEFE) + 12641940) / 2;

    protected static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        event.register((state, getter, pos, tintIndex) -> 0xFF000000 | ColorUtil.hsvToRGB(getter == null ? 0.45f : SimplexNoiseHelper.rippleFractalNoise(2, 128.0f, pos != null ? pos.above(128) : new BlockPos(0, 0, 0), 0.37f, 0.67f, 1.5f), 1.0f, 1.0f), new Block[]{(Block)TFBlocks.AURORA_BLOCK.get()});
        event.register((state, getter, pos, tintIndex) -> {
            int normalColor = blockColors.getColor(((Block)TFBlocks.AURORA_BLOCK.get()).defaultBlockState(), getter, pos, tintIndex);
            int red = normalColor >> 16 & 0xFF;
            int blue = normalColor & 0xFF;
            int green = normalColor >> 8 & 0xFF;
            float[] hsb = ColorUtil.rgbToHSV(red, green, blue);
            return 0xFF000000 | ColorUtil.hsvToRGB(hsb[0], hsb[1] * 0.5f, Math.min(hsb[2] + 0.4f, 0.9f));
        }, new Block[]{(Block)TFBlocks.AURORA_PILLAR.get(), (Block)TFBlocks.AURORA_SLAB.get(), (Block)TFBlocks.AURORALIZED_GLASS.get()});
        event.register((state, getter, pos, tintIndex) -> blockColors.getColor(Blocks.SHORT_GRASS.defaultBlockState(), getter, pos, tintIndex), new Block[]{(Block)TFBlocks.SMOKER.get(), (Block)TFBlocks.FIRE_JET.get()});
        event.register((state, getter, pos, tintIndex) -> getter != null && pos != null ? -14647248 : -9321636, new Block[]{(Block)TFBlocks.HUGE_LILY_PAD.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (getter == null || pos == null) {
                return -9790441;
            }
            int fade = pos.getX() * 16 + pos.getY() * 16 + pos.getZ() * 16;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 106.0f + fall * 251.0f);
            int green = (int)(spring * 156.0f + fall * 108.0f);
            int blue = (int)(spring * 23.0f + fall * 27.0f);
            return 0xFF000000 | red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.TIME_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (getter == null || pos == null) {
                return -9646870;
            }
            int fade = pos.getX() * 27 + pos.getY() * 63 + pos.getZ() * 39;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 108.0f + fall * 96.0f);
            int green = (int)(spring * 204.0f + fall * 107.0f);
            int blue = (int)(spring * 234.0f + fall * 121.0f);
            return 0xFF000000 | red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.TRANSFORMATION_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (getter == null || pos == null) {
                return -200380;
            }
            int fade = pos.getX() * 31 + pos.getY() * 33 + pos.getZ() * 32;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 252.0f + fall * 237.0f);
            int green = (int)(spring * 241.0f + fall * 172.0f);
            int blue = (int)(spring * 68.0f + fall * 9.0f);
            return 0xFF000000 | red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.MINING_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (getter == null || pos == null) {
                return -13218813;
            }
            int fade = pos.getX() * 63 + pos.getY() * 63 + pos.getZ() * 63;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 54.0f + fall * 168.0f);
            int green = (int)(spring * 76.0f + fall * 199.0f);
            int blue = (int)(spring * 3.0f + fall * 43.0f);
            return 0xFF000000 | red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.SORTING_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (getter == null || pos == null) {
                return -1;
            }
            float f = SimplexNoiseHelper.rippleFractalNoise(2, 32.0f, pos, 0.4f, 1.0f, 2.0f);
            return 0xFF000000 | ColorUtil.hsvToRGB(0.1f, 1.0f - f, (f + 2.0f) / 3.0f);
        }, new Block[]{(Block)TFBlocks.TOWERWOOD.get(), (Block)TFBlocks.CRACKED_TOWERWOOD.get(), (Block)TFBlocks.INFESTED_TOWERWOOD.get(), (Block)TFBlocks.MOSSY_TOWERWOOD.get()});
        event.register((state, getter, pos, tintIndex) -> getter != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)getter, (BlockPos)pos) : FoliageColor.getDefaultColor(), new Block[]{(Block)TFBlocks.TWILIGHT_OAK_LEAVES.get(), (Block)TFBlocks.DARK_LEAVES.get(), (Block)TFBlocks.HARDENED_DARK_LEAVES.get(), (Block)TFBlocks.GIANT_LEAVES.get(), (Block)TFBlocks.FALLEN_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> getter != null && pos != null ? CANOPY_COLORIZER.applyAsInt(BiomeColors.getAverageFoliageColor((BlockAndTintGetter)getter, (BlockPos)pos)) : FoliageColor.getEvergreenColor(), new Block[]{(Block)TFBlocks.CANOPY_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> getter != null && pos != null ? MANGROVE_COLORIZER.applyAsInt(BiomeColors.getAverageFoliageColor((BlockAndTintGetter)getter, (BlockPos)pos)) : FoliageColor.getBirchColor(), new Block[]{(Block)TFBlocks.MANGROVE_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (getter == null || pos == null) {
                return FoliageColor.getDefaultColor();
            }
            int red = pos.getX() * 32 + pos.getY() * 16;
            if ((red & 0x100) != 0) {
                red = 255 - (red & 0xFF);
            }
            red &= 0xFF;
            int green = pos.getY() * 32 + pos.getZ() * 16;
            if ((green & 0x100) != 0) {
                green = 255 - (green & 0xFF);
            }
            green ^= 0xFF;
            int blue = pos.getX() * 16 + pos.getZ() * 32;
            if ((blue & 0x100) != 0) {
                blue = 255 - (blue & 0xFF);
            }
            return 0xFF000000 | red << 16 | green << 8 | (blue &= 0xFF);
        }, new Block[]{(Block)TFBlocks.RAINBOW_OAK_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> FoliageColor.getEvergreenColor(), new Block[]{(Block)TFBlocks.BEANSTALK_LEAVES.get(), (Block)TFBlocks.THORN_LEAVES.get()});
        event.register((state, getter, pos, tintIndex) -> getter != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)getter, (BlockPos)pos) : GrassColor.getDefaultColor(), new Block[]{(Block)TFBlocks.FIDDLEHEAD.get(), (Block)TFBlocks.POTTED_FIDDLEHEAD.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return getter != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)getter, (BlockPos)pos) : GrassColor.getDefaultColor();
            }
            return -1;
        }, new Block[]{(Block)TFBlocks.HOLLOW_OAK_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_SPRUCE_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_BIRCH_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_JUNGLE_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_ACACIA_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_DARK_OAK_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_CRIMSON_STEM_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_WARPED_STEM_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_VANGROVE_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_CHERRY_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_CANOPY_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_MANGROVE_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_DARK_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_TIME_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_TRANSFORMATION_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_MINING_LOG_HORIZONTAL.get(), (Block)TFBlocks.HOLLOW_SORTING_LOG_HORIZONTAL.get()});
        event.register((state, getter, pos, tintIndex) -> {
            if (state.getValue(ClimbableHollowLogBlock.VARIANT) != HollowLogVariants.Climbable.VINE || tintIndex != 0) {
                return -1;
            }
            if (getter != null && pos != null) {
                return BiomeColors.getAverageFoliageColor((BlockAndTintGetter)getter, (BlockPos)pos);
            }
            return FoliageColor.getDefaultColor();
        }, new Block[]{(Block)TFBlocks.HOLLOW_OAK_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_SPRUCE_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_BIRCH_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_JUNGLE_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_ACACIA_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_DARK_OAK_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_CRIMSON_STEM_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_WARPED_STEM_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_VANGROVE_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_CANOPY_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_MANGROVE_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_DARK_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_TIME_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_TRANSFORMATION_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_MINING_LOG_CLIMBABLE.get(), (Block)TFBlocks.HOLLOW_SORTING_LOG_CLIMBABLE.get()});
        event.register((state, getter, pos, tintIndex) -> GrassColor.getDefaultColor(), new Block[]{(Block)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get(), (Block)TFBlocks.NAGA_COURTYARD_MINIATURE_STRUCTURE.get(), (Block)TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE.get()});
        event.register((state, getter, pos, tintIndex) -> -65281, new Block[]{(Block)TFBlocks.PINK_CASTLE_RUNE_BRICK.get(), (Block)TFBlocks.PINK_CASTLE_DOOR.get()});
        event.register((state, getter, pos, tintIndex) -> -16711681, new Block[]{(Block)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get(), (Block)TFBlocks.BLUE_CASTLE_DOOR.get()});
        event.register((state, getter, pos, tintIndex) -> -256, new Block[]{(Block)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get(), (Block)TFBlocks.YELLOW_CASTLE_DOOR.get()});
        event.register((state, getter, pos, tintIndex) -> -11861886, new Block[]{(Block)TFBlocks.VIOLET_CASTLE_RUNE_BRICK.get(), (Block)TFBlocks.VIOLET_CASTLE_DOOR.get()});
        event.register((state, getter, pos, tintIndex) -> -10743692, new Block[]{(Block)TFBlocks.VIOLET_FORCE_FIELD.get()});
        event.register((state, getter, pos, tintIndex) -> -391810, new Block[]{(Block)TFBlocks.PINK_FORCE_FIELD.get()});
        event.register((state, getter, pos, tintIndex) -> -42238, new Block[]{(Block)TFBlocks.ORANGE_FORCE_FIELD.get()});
        event.register((state, getter, pos, tintIndex) -> -7739647, new Block[]{(Block)TFBlocks.GREEN_FORCE_FIELD.get()});
        event.register((state, getter, pos, tintIndex) -> -15868161, new Block[]{(Block)TFBlocks.BLUE_FORCE_FIELD.get()});
    }

    protected static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        event.register((stack, tintIndex) -> {
            int n;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof BlockItem) {
                BlockItem blocc = (BlockItem)patt0$temp;
                n = blockColors.getColor(blocc.getBlock().defaultBlockState(), null, null, tintIndex);
            } else {
                n = -1;
            }
            return n;
        }, new ItemLike[]{(ItemLike)TFBlocks.AURORA_BLOCK.get(), (ItemLike)TFBlocks.AURORA_PILLAR.get(), (ItemLike)TFBlocks.AURORA_SLAB.get(), (ItemLike)TFBlocks.AURORALIZED_GLASS.get(), (ItemLike)TFBlocks.DARK_LEAVES.get(), (ItemLike)TFBlocks.GIANT_LEAVES.get(), (ItemLike)TFBlocks.SMOKER.get(), (ItemLike)TFBlocks.FIRE_JET.get(), (ItemLike)TFBlocks.TIME_LEAVES.get(), (ItemLike)TFBlocks.TRANSFORMATION_LEAVES.get(), (ItemLike)TFBlocks.MINING_LEAVES.get(), (ItemLike)TFBlocks.SORTING_LEAVES.get(), (ItemLike)TFBlocks.TWILIGHT_OAK_LEAVES.get(), (ItemLike)TFBlocks.CANOPY_LEAVES.get(), (ItemLike)TFBlocks.MANGROVE_LEAVES.get(), (ItemLike)TFBlocks.RAINBOW_OAK_LEAVES.get(), (ItemLike)TFBlocks.THORN_LEAVES.get(), (ItemLike)TFBlocks.BEANSTALK_LEAVES.get(), (ItemLike)TFBlocks.FALLEN_LEAVES.get(), (ItemLike)TFBlocks.FIDDLEHEAD.get(), (ItemLike)TFBlocks.POTTED_FIDDLEHEAD.get(), (ItemLike)TFBlocks.PINK_CASTLE_RUNE_BRICK.get(), (ItemLike)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get(), (ItemLike)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get(), (ItemLike)TFBlocks.VIOLET_CASTLE_RUNE_BRICK.get(), (ItemLike)TFBlocks.YELLOW_CASTLE_DOOR.get(), (ItemLike)TFBlocks.BLUE_CASTLE_DOOR.get(), (ItemLike)TFBlocks.PINK_CASTLE_DOOR.get(), (ItemLike)TFBlocks.VIOLET_CASTLE_DOOR.get(), (ItemLike)TFBlocks.PINK_FORCE_FIELD.get(), (ItemLike)TFBlocks.BLUE_FORCE_FIELD.get(), (ItemLike)TFBlocks.GREEN_FORCE_FIELD.get(), (ItemLike)TFBlocks.ORANGE_FORCE_FIELD.get(), (ItemLike)TFBlocks.VIOLET_FORCE_FIELD.get(), (ItemLike)TFBlocks.HUGE_LILY_PAD.get(), (ItemLike)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get(), (ItemLike)TFBlocks.NAGA_COURTYARD_MINIATURE_STRUCTURE.get(), (ItemLike)TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE.get()});
        event.register((stack, index) -> index != 1 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-4337703), new ItemLike[]{(ItemLike)TFItems.ARCTIC_HELMET.get(), (ItemLike)TFItems.ARCTIC_CHESTPLATE.get(), (ItemLike)TFItems.ARCTIC_LEGGINGS.get(), (ItemLike)TFItems.ARCTIC_BOOTS.get()});
        event.register((stack, index) -> {
            if (index > 0) {
                return -1;
            }
            PotionFlaskComponent contents = (PotionFlaskComponent)stack.getOrDefault(TFDataComponents.POTION_FLASK_CONTENTS, (Object)PotionFlaskComponent.EMPTY);
            if (contents.potion().potion().isEmpty()) {
                return -1;
            }
            return contents.potion().getColor();
        }, new ItemLike[]{(ItemLike)TFItems.BRITTLE_FLASK.get(), (ItemLike)TFItems.GREATER_FLASK.get()});
        for (DeferredSpawnEggItem egg : TFEntities.SPAWN_EGGS.getEntries().stream().map(DeferredHolder::get).map(DeferredSpawnEggItem.class::cast).toList()) {
            event.register((stack, index) -> FastColor.ARGB32.opaque((int)egg.getColor(index)), new ItemLike[]{egg});
        }
    }
}

