/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.monster.Troll;

public class TrollModel
extends HumanoidModel<Troll> {
    public TrollModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? TrollModel.createJappaModel() : TrollModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -3.0f, 10.0f, 10.0f, 10.0f), PartPose.offset((float)0.0f, (float)-9.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 21).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(40, 0).addBox(-8.0f, 0.0f, -5.0f, 16.0f, 26.0f, 10.0f), PartPose.offset((float)0.0f, (float)-14.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(32, 36).addBox(-5.0f, -2.0f, -3.0f, 6.0f, 22.0f, 6.0f), PartPose.offset((float)-9.0f, (float)-9.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(32, 36).addBox(-1.0f, -2.0f, -3.0f, 6.0f, 22.0f, 6.0f), PartPose.offset((float)9.0f, (float)-9.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 44).addBox(-3.0f, 0.0f, -4.0f, 6.0f, 12.0f, 8.0f), PartPose.offset((float)-5.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(0, 44).addBox(-3.0f, 0.0f, -4.0f, 6.0f, 12.0f, 8.0f), PartPose.offset((float)5.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(52, 31).addBox(-5.0f, -8.0f, -8.0f, 10.0f, 10.0f, 10.0f).texOffs(36, 41).addBox(-2.0f, -4.0f, -11.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)-11.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -37.0f, -6.0f, 16.0f, 26.0f, 15.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 41).addBox(-6.0f, -1.0f, -4.0f, 6.0f, 25.0f, 8.0f), PartPose.offset((float)-8.0f, (float)-9.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(0, 41).addBox(0.0f, -1.0f, -4.0f, 6.0f, 25.0f, 8.0f), PartPose.offset((float)8.0f, (float)-9.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(28, 54).addBox(-3.0f, -1.0f, -4.0f, 6.0f, 12.0f, 8.0f), PartPose.offset((float)-4.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(28, 54).addBox(-3.0f, -1.0f, -4.0f, 6.0f, 12.0f, 8.0f), PartPose.offset((float)4.0f, (float)13.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Troll entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.hat.yRot = this.head.yRot;
        this.hat.xRot = this.head.xRot;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        if (entity.isVehicle()) {
            this.rightArm.xRot = (float)Math.PI;
            this.leftArm.xRot = (float)Math.PI;
        } else {
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        }
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        if (this.leftArmPose != HumanoidModel.ArmPose.EMPTY) {
            this.rightArm.xRot += (float)Math.PI;
        }
        if (this.rightArmPose != HumanoidModel.ArmPose.EMPTY) {
            this.leftArm.xRot += (float)Math.PI;
        }
        if (this.attackTime > 0.0f) {
            float swing = 1.0f - this.attackTime;
            this.rightArm.xRot -= (float)Math.PI * swing;
            this.leftArm.xRot -= (float)Math.PI * swing;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        if (!entity.isVehicle()) {
            AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        }
    }

    public void prepareMobModel(Troll entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        if (entity.getTarget() != null) {
            this.rightArm.xRot += (float)Math.PI;
            this.leftArm.xRot += (float)Math.PI;
        }
    }
}

