/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.block;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.RedThreadBlockEntity;
import twilightforest.client.TFShaders;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.RedThreadModel;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.custom.TravellersModifiersManager;

public class RedThreadRenderer<T extends RedThreadBlockEntity>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("red_thread.png");
    private final RedThreadModel redThreadModel;
    private static final RenderType GLOW = RenderType.create((String)"twilightforest:glow", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(new RenderStateShard.LightmapStateShard(true)).setCullState(new RenderStateShard.CullStateShard(true)).setDepthTestState(new RenderStateShard.DepthTestStateShard("always", 519)).setShaderState(new RenderStateShard.ShaderStateShard(() -> TFShaders.RED_THREAD)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TEXTURE, false, true)).createCompositeState(true));

    public RedThreadRenderer(BlockEntityRendererProvider.Context context) {
        this.redThreadModel = new RedThreadModel(context.bakeLayer(TFModelLayers.RED_THREAD));
    }

    public void render(T entity, float ticks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = entity.getBlockState();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        boolean wearsActivatedTravellersGoggles = (Boolean)player.getData(TFDataAttachments.TRAVELLERS_GOGGLES_RED_THREAD_VISION) != false && TravellersModifiersManager.isModifierActive((LivingEntity)player, TravellersModifiersManager.RED_THREAD_VISION_MODIFIER);
        boolean glow = player.isHolding(((Block)TFBlocks.RED_THREAD.get()).asItem()) || wearsActivatedTravellersGoggles;
        for (Direction face : Direction.values()) {
            if (!((Boolean)state.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(face))).booleanValue()) continue;
            stack.pushPose();
            Vec3 xyz = RedThreadRenderer.getXYZ(face);
            stack.translate(xyz.x, xyz.y, xyz.z);
            stack.mulPose(Axis.ZP.rotationDegrees(RedThreadRenderer.getZPDegrees(face)));
            stack.mulPose(Axis.XP.rotationDegrees(RedThreadRenderer.getXPDegrees(face)));
            stack.pushPose();
            stack.translate(0.5, 0.0, 0.5);
            this.render(entity, face, stack, glow ? buffer.getBuffer(GLOW) : buffer.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE)), glow ? 0xF000F0 : light);
            stack.popPose();
            stack.popPose();
        }
    }

    private void render(T entity, Direction face, PoseStack stack, VertexConsumer consumer, int light) {
        Level level = entity.getLevel();
        BlockPos pos = entity.getBlockPos();
        this.redThreadModel.renderCenterPiece(stack, consumer, light);
        for (Direction direction : Direction.values()) {
            if (direction.getAxis().equals((Object)face.getAxis())) continue;
            boolean flag = (Boolean)entity.getBlockState().getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction));
            if (!flag && level != null) {
                BlockState state = level.getBlockState(pos.relative(direction));
                boolean bl = flag = state.getBlock().equals(TFBlocks.RED_THREAD.get()) && (Boolean)state.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(face)) != false;
                if (!flag) {
                    state = level.getBlockState(pos.relative(direction).relative(face));
                    boolean threadBlocked = level.getBlockState(pos.relative(direction)).isFaceSturdy((BlockGetter)level, pos, direction.getOpposite());
                    boolean bl2 = flag = state.is((Block)TFBlocks.RED_THREAD.get()) && !threadBlocked && (Boolean)state.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction.getOpposite())) != false;
                }
            }
            if (!flag) continue;
            this.redThreadModel.getPart(face, direction).render(stack, consumer, light, OverlayTexture.NO_OVERLAY);
        }
    }

    private static Vec3 getXYZ(Direction face) {
        return new Vec3(face == Direction.EAST || face == Direction.UP ? 1.0 : 0.0, face == Direction.WEST || face == Direction.UP || face == Direction.NORTH ? 1.0 : 0.0, face == Direction.SOUTH ? 1.0 : 0.0);
    }

    private static float getZPDegrees(Direction face) {
        return switch (face) {
            case Direction.EAST -> 90.0f;
            case Direction.UP -> 180.0f;
            case Direction.WEST -> 270.0f;
            default -> 0.0f;
        };
    }

    private static float getXPDegrees(Direction face) {
        return switch (face) {
            case Direction.NORTH -> 90.0f;
            case Direction.SOUTH -> 270.0f;
            default -> 0.0f;
        };
    }
}

