/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import twilightforest.entity.SlideBlock;

public class SlideBlockRenderer
extends EntityRenderer<SlideBlock> {
    public SlideBlockRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.0f;
    }

    public void render(SlideBlock entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        Level level;
        BlockState blockstate = entity.getBlockState();
        if (blockstate.getRenderShape() == RenderShape.MODEL && blockstate != (level = entity.level()).getBlockState(entity.blockPosition()) && blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            stack.pushPose();
            BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
            if (blockstate.getProperties().contains(RotatedPillarBlock.AXIS)) {
                Direction.Axis axis = (Direction.Axis)blockstate.getValue((Property)RotatedPillarBlock.AXIS);
                float angle = ((float)entity.tickCount + partialTicks) * 60.0f;
                stack.translate(0.0, 0.5, 0.0);
                if (axis == Direction.Axis.Y) {
                    stack.mulPose(Axis.YP.rotationDegrees(angle));
                } else if (axis == Direction.Axis.X) {
                    stack.mulPose(Axis.XP.rotationDegrees(angle));
                } else if (axis == Direction.Axis.Z) {
                    stack.mulPose(Axis.ZP.rotationDegrees(angle));
                }
                stack.translate(-0.5, -0.5, -0.5);
            }
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            BakedModel model = dispatcher.getBlockModel(blockstate);
            for (RenderType renderType : model.getRenderTypes(blockstate, RandomSource.create((long)blockstate.getSeed(entity.blockPosition())), ModelData.EMPTY)) {
                dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, blockstate, blockpos, stack, buffer.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType)), false, RandomSource.create(), blockstate.getSeed(entity.blockPosition()), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
            }
            stack.popPose();
            super.render((Entity)entity, yaw, partialTicks, stack, buffer, light);
        }
    }

    public ResourceLocation getTextureLocation(SlideBlock entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

