/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import twilightforest.entity.TFPart;

public abstract class TFPartRenderer<T extends TFPart<?>, M extends ListModel<T>>
extends EntityRenderer<T> {
    protected final M model;

    public TFPartRenderer(EntityRendererProvider.Context context, M model) {
        super(context);
        this.model = model;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.pushPose();
        float yRot = Mth.rotLerp((float)partialTicks, (float)((TFPart)((Object)entity)).prevRenderYawOffset, (float)((TFPart)((Object)entity)).renderYawOffset);
        float xRot = Mth.lerp((float)partialTicks, (float)((TFPart)((Object)entity)).xRotO, (float)entity.getXRot());
        float ageInTicks = this.getBob(entity, partialTicks);
        this.setupRotations(entity, stack, partialTicks);
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(0.0, (double)-1.501f, 0.0);
        this.model.prepareMobModel(entity, 0.0f, 0.0f, partialTicks);
        this.model.setupAnim(entity, 0.0f, 0.0f, ageInTicks, yRot, xRot);
        boolean visible = this.isBodyVisible(entity);
        boolean ghostly = !visible && !entity.isInvisibleTo((Player)Minecraft.getInstance().player);
        boolean glowing = Minecraft.getInstance().shouldEntityAppearGlowing(entity);
        RenderType rendertype = this.getRenderType(entity, visible, ghostly, glowing);
        if (rendertype != null) {
            VertexConsumer consumer = buffer.getBuffer(rendertype);
            int overlay = this.getOverlayCoords(entity, 0.0f);
            this.model.renderToBuffer(stack, consumer, light, overlay, ghostly ? 0x26FFFFFF : -1);
        }
        stack.popPose();
        super.render(entity, entityYaw, partialTicks, stack, buffer, light);
    }

    public int getOverlayCoords(T entity, float u) {
        Entity entity2 = entity.getParent();
        if (entity2 instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            return OverlayTexture.pack((int)OverlayTexture.u((float)u), (int)OverlayTexture.v((living.hurtTime > 0 || living.deathTime > 0 || ((TFPart)((Object)entity)).hurtTime > 0 || ((TFPart)((Object)entity)).deathTime > 0 ? 1 : 0) != 0));
        }
        return OverlayTexture.pack((int)OverlayTexture.u((float)u), (int)OverlayTexture.v((((TFPart)((Object)entity)).hurtTime > 0 || ((TFPart)((Object)entity)).deathTime > 0 ? 1 : 0) != 0));
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean visible, boolean ghostly, boolean glowing) {
        ResourceLocation resourcelocation = this.getTextureLocation((Entity)entity);
        if (ghostly) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourcelocation);
        }
        if (visible) {
            return this.model.renderType(resourcelocation);
        }
        return glowing ? RenderType.outline((ResourceLocation)resourcelocation) : null;
    }

    protected float getBob(T entity, float partialTicks) {
        return (float)((TFPart)((Object)entity)).tickCount + partialTicks;
    }

    protected void setupRotations(T entity, PoseStack stack, float partialTicks) {
        if (((TFPart)((Object)entity)).deathTime > 0) {
            float f = ((float)((TFPart)((Object)entity)).deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            stack.mulPose(Axis.of((Vector3f)entity.getDirection().step()).rotationDegrees(f * this.getFlipDegrees(entity)));
        } else if (this.isEntityUpsideDown(entity)) {
            stack.translate(0.0f, entity.getBbHeight() + 0.1f, 0.0f);
            stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected float getFlipDegrees(T entity) {
        return 90.0f;
    }

    protected boolean isBodyVisible(T entity) {
        return !((TFPart)((Object)entity)).isInvisible();
    }

    private boolean isEntityUpsideDown(T entity) {
        if (entity.hasCustomName()) {
            String s = ChatFormatting.stripFormatting((String)entity.getName().getString());
            return s != null && (s.equalsIgnoreCase("dinnerbone") || s.equalsIgnoreCase("grumm"));
        }
        return false;
    }
}

