/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.emi.widget;

import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import twilightforest.TwilightForestMod;
import twilightforest.util.entities.EntityRenderingUtil;

public class EmiItemEntityWidget
extends Widget {
    private final ItemStack stack;
    private final Bounds bounds;
    private final float bobOffs;

    public EmiItemEntityWidget(ItemLike item, int x, int y) {
        this(new ItemStack(item), x, y);
    }

    public EmiItemEntityWidget(ItemStack stack, int x, int y) {
        this.stack = stack;
        this.bounds = new Bounds(x, y, 32, 32);
        this.bobOffs = RandomSource.create().nextFloat() * (float)Math.PI * 2.0f;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        ArrayList<ClientTooltipComponent> tooltip = new ArrayList<ClientTooltipComponent>();
        tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)this.stack.getDescriptionId()).getVisualOrderText()));
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).toString()).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText()));
        }
        tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)EntityRenderingUtil.getModIdForTooltip(BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getNamespace())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}).getVisualOrderText()));
        return tooltip;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.pose().pushPose();
        graphics.pose().translate((double)this.bounds.x(), (double)this.bounds.y(), 0.0);
        try {
            EntityRenderingUtil.renderItemEntity(graphics, this.stack, (Level)Minecraft.getInstance().level, this.bobOffs);
        }
        catch (Exception e) {
            TwilightForestMod.LOGGER.error("Error drawing item in EMI!", (Throwable)e);
        }
        graphics.pose().popPose();
    }
}

