/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.gameevent.GameEvent;
import twilightforest.entity.SpikeBlock;
import twilightforest.entity.monster.BlockChainGoblin;

public class ThrowSpikeBlockGoal
extends Goal {
    protected final BlockChainGoblin attacker;
    protected final SpikeBlock spikeBlock;
    private int cooldown;

    public ThrowSpikeBlockGoal(BlockChainGoblin goblin, SpikeBlock block) {
        this.attacker = goblin;
        this.spikeBlock = block;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity target = this.attacker.getTarget();
        if (target == null || this.attacker.distanceToSqr((Entity)target) > 42.0 || this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return this.attacker.isAlive() && this.attacker.hasLineOfSight((Entity)target) && this.attacker.level().getRandom().nextInt(56) == 0;
    }

    public boolean canContinueToUse() {
        return this.attacker.getChainMoveLength() > 0.0f;
    }

    public void start() {
        this.attacker.setThrowing(true);
        this.cooldown = 100 + this.attacker.level().getRandom().nextInt(100);
        this.attacker.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
    }
}

