/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBlocks;
import twilightforest.loot.TFLootTables;
import twilightforest.world.components.structures.markerhandler.BlockPlaceMarkerHandler;
import twilightforest.world.components.structures.markerhandler.DryingRackMarkerHandler;
import twilightforest.world.components.structures.markerhandler.LootMarkerHandler;
import twilightforest.world.components.structures.markerhandler.PaintingMarkerHandler;
import twilightforest.world.components.structures.markerhandler.RotationMarkerHandler;
import twilightforest.world.components.structures.markerhandler.SwitchMarkerHandler;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandler;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandlerType;
import twilightforest.world.components.structures.util.TemplateMarkerHandlerList;

public class TemplateMarkerHandlers {
    public static final DeferredRegister<TemplateMarkerHandlerType> TEMPLATE_MARKER_HANDLER_TYPES = DeferredRegister.create(TFRegistries.Keys.TEMPLATE_MARKER_HANDLER_TYPE, (String)"twilightforest");
    public static final Codec<TemplateMarkerHandlerType> TYPE_CODEC = Codec.lazyInitialized(() -> TFRegistries.TEMPLATE_MARKER_HANDLER_TYPES.byNameCodec());
    public static final Codec<TemplateMarkerHandler> DISPATCH_CODEC = TYPE_CODEC.dispatch("type", TemplateMarkerHandler::getType, TemplateMarkerHandlerType::getCodec);
    public static final Codec<Holder<TemplateMarkerHandler>> HOLDER_CODEC = RegistryFileCodec.create(TFRegistries.Keys.TEMPLATE_MARKER_HANDLER, DISPATCH_CODEC);
    public static final DeferredHolder<TemplateMarkerHandlerType, TemplateMarkerHandlerType> BLOCK_PLACEMENT = TEMPLATE_MARKER_HANDLER_TYPES.register("block_placement", () -> () -> BlockPlaceMarkerHandler.CODEC);
    public static final DeferredHolder<TemplateMarkerHandlerType, TemplateMarkerHandlerType> HANDLER_SWITCH = TEMPLATE_MARKER_HANDLER_TYPES.register("handler_switch", () -> () -> SwitchMarkerHandler.CODEC);
    public static final DeferredHolder<TemplateMarkerHandlerType, TemplateMarkerHandlerType> ROTATION = TEMPLATE_MARKER_HANDLER_TYPES.register("rotation", () -> () -> RotationMarkerHandler.CODEC);
    public static final DeferredHolder<TemplateMarkerHandlerType, TemplateMarkerHandlerType> DRYING_RACK = TEMPLATE_MARKER_HANDLER_TYPES.register("drying_rack", () -> () -> DryingRackMarkerHandler.CODEC);
    public static final DeferredHolder<TemplateMarkerHandlerType, TemplateMarkerHandlerType> PAINTING = TEMPLATE_MARKER_HANDLER_TYPES.register("painting", () -> () -> PaintingMarkerHandler.CODEC);
    public static final DeferredHolder<TemplateMarkerHandlerType, TemplateMarkerHandlerType> LOOT = TEMPLATE_MARKER_HANDLER_TYPES.register("loot", () -> () -> LootMarkerHandler.CODEC);
    public static final ResourceKey<TemplateMarkerHandlerList> CAMP_MARKER_HANDLERS = ResourceKey.create(TFRegistries.Keys.TEMPLATE_MARKER_HANDLER_LIST, (ResourceLocation)TwilightForestMod.prefix("camp_marker_handlers"));

    public static void bootstrap(BootstrapContext<TemplateMarkerHandlerList> context) {
        BlockPlaceMarkerHandler campfireSeat = new BlockPlaceMarkerHandler((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)TFBlocks.TWILIGHT_OAK_SLAB.value()).defaultBlockState()).add((Object)Blocks.AIR.defaultBlockState(), 3).build()));
        DryingRackMarkerHandler armorRack = new DryingRackMarkerHandler((BlockStateProvider)SimpleStateProvider.simple((Block)((Block)TFBlocks.CANOPY_DRYING_RACK.value())), TFLootTables.CAMP_ARMOR_RACK);
        DryingRackMarkerHandler birchDryingRack = new DryingRackMarkerHandler((BlockStateProvider)SimpleStateProvider.simple((Block)((Block)TFBlocks.BIRCH_DRYING_RACK.value())), TFLootTables.CAMP_DRYING_RACK);
        PaintingMarkerHandler painting = new PaintingMarkerHandler((TagKey<PaintingVariant>)PaintingVariantTags.PLACEABLE);
        LootMarkerHandler tentPot = new LootMarkerHandler((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.DECORATED_POT), TFLootTables.CAMP_POT);
        Map<String, Holder<TemplateMarkerHandler>> keyedHandlers = Map.of("twilight_oak_slab", Holder.direct((Object)campfireSeat), "camp_armor_rack", Holder.direct((Object)armorRack), "birch_drying_rack", Holder.direct((Object)birchDryingRack), "painting", Holder.direct((Object)painting), "tent_pot", Holder.direct((Object)tentPot));
        context.register(CAMP_MARKER_HANDLERS, (Object)TemplateMarkerHandlerList.of(new RotationMarkerHandler((Holder<TemplateMarkerHandler>)Holder.direct((Object)new SwitchMarkerHandler(keyedHandlers)))));
    }
}

