/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.recipe.travellers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import twilightforest.data.helpers.TFLangProvider;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.travellers_gear.modifiers.TravellersModifiable;
import twilightforest.item.travellers_gear.modifiers.TravellersModifier;

public abstract class TravellersGearModifierRecipe
extends CustomRecipe {
    protected final ResourceKey<TravellersModifier> travellersModifierKey;

    public TravellersGearModifierRecipe(ResourceKey<TravellersModifier> travellersModifier) {
        super(CraftingBookCategory.EQUIPMENT);
        this.travellersModifierKey = travellersModifier;
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        ItemStack stack = TravellersGearModifierRecipe.getModifiableArmor(input);
        if (stack == null) {
            return false;
        }
        int slots = 0;
        Item item = stack.getItem();
        if (item instanceof TravellersModifiable) {
            TravellersModifiable travellersModifiableItem = (TravellersModifiable)item;
            slots = travellersModifiableItem.getModifierSlots();
        }
        return TravellersModifiersManager.countInsertableModifiers((HolderLookup.Provider)level.registryAccess(), stack) < (long)slots && !TravellersModifiersManager.hasTravellersModifier((HolderLookup.Provider)level.registryAccess(), stack, this.travellersModifierKey) && TravellersModifiersManager.getModifierDataComponentProviders((HolderLookup.Provider)level.registryAccess(), input.items().stream().map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0})).toList(), this.travellersModifierKey) <= 1;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        ItemStack travellerArmorStack = TravellersGearModifierRecipe.getModifiableArmor(input);
        if (travellerArmorStack == null) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = travellerArmorStack.copy();
        return this.applyModifier(registries, stack, input.items().stream().map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0})).toList());
    }

    public ItemStack applyModifier(HolderLookup.Provider registries, ItemStack stack, List<Ingredient> inputs) {
        if (TravellersModifiersManager.transferModifier(registries, stack, inputs, this.travellersModifierKey)) {
            return stack;
        }
        boolean modifierAdded = TravellersModifiersManager.addModifier(registries, stack, this.travellersModifierKey);
        return modifierAdded ? stack : ItemStack.EMPTY;
    }

    public abstract boolean isShapeless();

    public abstract int getWidth();

    public abstract int getHeight();

    @Nullable
    protected static ItemStack getModifiableArmor(CraftingInput input) {
        return TravellersGearModifierRecipe.getModifiableArmor(input.items());
    }

    @Nullable
    protected static ItemStack getModifiableArmor(Iterable<ItemStack> items) {
        return StreamSupport.stream(items.spliterator(), false).filter(stack -> {
            TravellersModifiable modifiable;
            Item patt0$temp = stack.getItem();
            return patt0$temp instanceof TravellersModifiable && (modifiable = (TravellersModifiable)patt0$temp).getModifierSlots() > 0;
        }).findFirst().orElse(null);
    }

    public static ItemStack getModifiableArmorFromIngredients(Iterable<Ingredient> ingredients) {
        return StreamSupport.stream(ingredients.spliterator(), false).flatMap(ingredient -> Arrays.stream(ingredient.getItems())).filter(stack -> stack.getItem() instanceof TravellersModifiable).findFirst().orElseThrow();
    }

    public ResourceLocation getId() {
        return this.travellersModifierKey.location().withPrefix(StringUtils.substringAfterLast((String)TravellersGearModifierRecipe.getModifiableArmorFromIngredients((Iterable<Ingredient>)this.getIngredients()).getDescriptionId(), (int)46) + "/").withPrefix("add_modifier_to_travellers_gear/").withSuffix("_modifier");
    }

    public ResourceKey<TravellersModifier> getTravellersModifierKey() {
        return this.travellersModifierKey;
    }

    public static class AbstractModifierRecipeSerializer<T extends TravellersGearModifierRecipe>
    implements RecipeSerializer<T> {
        protected final MapCodec<T> codec;

        protected AbstractModifierRecipeSerializer(MapCodec<T> codec) {
            this.codec = codec;
        }

        @NotNull
        public MapCodec<T> codec() {
            return this.codec;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return StreamCodec.of(this::toNetwork, this::fromNetwork);
        }

        public T fromNetwork(RegistryFriendlyByteBuf buf) {
            RegistryOps registryops = buf.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            JsonElement jsonelementDeserialized = (JsonElement)GsonHelper.fromJson((Gson)TFLangProvider.GSON, (String)buf.readUtf(), JsonElement.class);
            return (T)((Object)((TravellersGearModifierRecipe)((Object)((Pair)this.codec.codec().decode((DynamicOps)registryops, (Object)jsonelementDeserialized).getOrThrow()).getFirst())));
        }

        public void toNetwork(RegistryFriendlyByteBuf buf, T recipe) {
            RegistryOps registryops = buf.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            JsonElement jsonelement = (JsonElement)this.codec.codec().encodeStart((DynamicOps)registryops, recipe).getOrThrow();
            buf.writeUtf(jsonelement.toString());
        }
    }
}

