/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.travellers_gear;

import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import twilightforest.TwilightForestMod;
import twilightforest.components.entity.SlimySolesAttachment;
import twilightforest.init.TFAttributeModifiers;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFDimensionData;
import twilightforest.init.TFItems;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.network.ParticlePacket;
import twilightforest.util.TFMathUtil;

public class TravellersGearLogic {
    public static final double WATER_WALKING_MAX_SUBMERGED_HEIGHT = 0.4;
    private static final double AUTO_REPAIR_SUNLIGHT_BOOST = 3.0;
    private static final double AUTO_REPAIR_TWILIGHT_BOOST = 1.5;

    public static void travellersStealth(Player player, Consumer<Player> invisibilityHandler) {
        if (!TravellersModifiersManager.isModifierActive((LivingEntity)player, TravellersModifiersManager.STEALTH_MODIFIER)) {
            return;
        }
        if (player.isCrouching()) {
            invisibilityHandler.accept(player);
        } else {
            MobEffectInstance invisibilityEffect = player.getEffect(MobEffects.INVISIBILITY);
            if (invisibilityEffect != null && invisibilityEffect.getDuration() < 2) {
                player.setInvisible(false);
            }
        }
    }

    public static void waterWalkingSplashEffect(LivingEntity livingEntity) {
        Long lastTickWaterWalking = (Long)livingEntity.getData(TFDataAttachments.LAST_TICK_WATER_WALKING);
        Level level = livingEntity.level();
        Vec3 livingEntityVelocity = livingEntity.getKnownMovement();
        if (lastTickWaterWalking + 1L == level.getGameTime() || livingEntityVelocity.horizontalDistance() < 0.01) {
            return;
        }
        livingEntity.setData(TFDataAttachments.LAST_TICK_WATER_WALKING, (Object)livingEntity.level().getGameTime());
        ParticlePacket particlePacket = new ParticlePacket();
        int particleNumber = 0;
        while ((float)particleNumber < livingEntity.dimensions.width()) {
            double dx = (level.random.nextDouble() * 2.0 - 1.0) * (double)livingEntity.dimensions.width() / 2.0;
            double dz = (level.random.nextDouble() * 2.0 - 1.0) * (double)livingEntity.dimensions.width() / 2.0;
            Vec3 particlePos = new Vec3(livingEntity.getX() + dx, livingEntity.getY() + 0.4, livingEntity.getZ() + dz);
            Vec3 particleVelocity = new Vec3(-livingEntityVelocity.x, 0.5, -livingEntityVelocity.z);
            if (level.isClientSide()) {
                level.addParticle((ParticleOptions)ParticleTypes.SPLASH, false, particlePos.x(), particlePos.y(), particlePos.z(), particleVelocity.x(), particleVelocity.y(), particleVelocity.z());
            } else {
                particlePacket.queueParticle((ParticleOptions)ParticleTypes.SPLASH, false, particlePos, particleVelocity);
            }
            ++particleNumber;
        }
        if (!level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)livingEntity, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static boolean isBelowMaxWaterWalkingSubmergedHeight(LivingEntity livingEntity) {
        double waterHeight = livingEntity.getFluidTypeHeight((FluidType)NeoForgeMod.WATER_TYPE.value());
        return waterHeight < 0.4;
    }

    public static void travellersBootsStraightAhead(LivingEntity livingEntity) {
        boolean hasModifier;
        ItemStack leggingsStack = livingEntity.getItemBySlot(EquipmentSlot.FEET);
        Double multiplier = (Double)leggingsStack.get(TFDataComponents.STRAIGHT_AHEAD_MULTIPLIER);
        AttributeInstance attributeInstance = livingEntity.getAttributes().getInstance(Attributes.MOVEMENT_SPEED);
        if (attributeInstance == null) {
            return;
        }
        if (multiplier == null) {
            multiplier = 1.0;
        }
        boolean bl = hasModifier = TravellersModifiersManager.isModifierActive((Entity)livingEntity, leggingsStack, TravellersModifiersManager.STRAIGHT_AHEAD_MODIFIER) && multiplier != 1.0;
        if (hasModifier == attributeInstance.hasModifier(TFAttributeModifiers.STRAIGHT_AHEAD_ATTRIBUTE_MODIFIER_LOCATION)) {
            return;
        }
        if (hasModifier) {
            attributeInstance.addOrUpdateTransientModifier(new AttributeModifier(TFAttributeModifiers.STRAIGHT_AHEAD_ATTRIBUTE_MODIFIER_LOCATION, multiplier - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        } else {
            attributeInstance.removeModifier(TFAttributeModifiers.STRAIGHT_AHEAD_ATTRIBUTE_MODIFIER_LOCATION);
        }
    }

    public static void travellersWingsSidestepCooldownSound(Player player) {
        ItemStack leggingsStack = player.getItemBySlot(EquipmentSlot.LEGS);
        Long cooldown = (Long)leggingsStack.get(TFDataComponents.SIDESTEP_COOLDOWN);
        if (cooldown == null) {
            return;
        }
        long dt = player.level().getGameTime() - (Long)player.getData(TFDataAttachments.LAST_SIDESTEP_TIME);
        Boolean shouldPlaySound = (Boolean)player.getData(TFDataAttachments.SHOULD_PLAY_SIDE_STEP_COOLDOWN_SOUND);
        if (TravellersModifiersManager.isModifierActive((Entity)player, leggingsStack, TravellersModifiersManager.SIDESTEP_MODIFIER) && dt > cooldown && shouldPlaySound.booleanValue()) {
            player.playSound((SoundEvent)TFSounds.SIDE_STEP_CHARGED.get(), 1.0f, player.getVoicePitch());
            player.setData(TFDataAttachments.SHOULD_PLAY_SIDE_STEP_COOLDOWN_SOUND, (Object)false);
        }
    }

    public static void travellersWingsGradualGlide(LivingEntity livingEntity) {
        Player player;
        boolean isGraduallyGliding;
        ItemStack leggingsStack = livingEntity.getItemBySlot(EquipmentSlot.LEGS);
        Float multiplier = (Float)leggingsStack.get(TFDataComponents.GRADUALLY_GLIDING_MULTIPLIER);
        Vec3 deltaMovement = livingEntity.getDeltaMovement();
        if (!TravellersModifiersManager.isModifierActive((Entity)livingEntity, leggingsStack, TravellersModifiersManager.GRADUAL_GLIDE_MODIFIER) || multiplier == null || deltaMovement.y() >= 0.0 || livingEntity.isFallFlying()) {
            return;
        }
        boolean bl = isGraduallyGliding = !(livingEntity instanceof Player) || (Boolean)(player = (Player)livingEntity).getData(TFDataAttachments.IS_GRADUALLY_GLIDING) != false;
        if (!isGraduallyGliding) {
            return;
        }
        double newDeltaMovementY = deltaMovement.y() * (double)multiplier.floatValue();
        livingEntity.setDeltaMovement(deltaMovement.x(), newDeltaMovementY, deltaMovement.z());
        livingEntity.fallDistance = (float)(Math.pow(newDeltaMovementY, 2.0) / 2.0 / livingEntity.getGravity());
    }

    public static void travellersGearAutoRepair(LivingEntity livingEntity) {
        long lastHitTime = (Long)livingEntity.getData(TFDataAttachments.LAST_DAMAGE_ARMOR_TIME);
        if (livingEntity.level().getGameTime() - lastHitTime <= 200L) {
            return;
        }
        livingEntity.getArmorSlots().forEach(slot -> {
            Float probability = (Float)slot.get(TFDataComponents.AUTO_REPAIR_PROBABILITY);
            if (probability == null || !TravellersModifiersManager.isModifierActive((Entity)livingEntity, slot, TravellersModifiersManager.AUTO_REPAIR_MODIFIER)) {
                return;
            }
            Level level = livingEntity.level();
            double boostedProbability = TravellersGearLogic.getAutoRepairChance(probability.floatValue(), level, livingEntity.blockPosition());
            if (boostedProbability > (double)level.random.nextFloat()) {
                slot.setDamageValue(Math.max(slot.getDamageValue() - 1, 0));
            }
        });
    }

    private static double getAutoRepairChance(double baseProb, Level level, BlockPos pos) {
        double boostFactor;
        if (!level.canSeeSky(pos)) {
            return baseProb;
        }
        if (level.dimensionTypeRegistration().is(TFDimensionData.TWILIGHT_DIM_TYPE)) {
            boostFactor = 1.5;
        } else if (level.isDay()) {
            boostFactor = 3.0;
        } else {
            return baseProb;
        }
        return TFMathUtil.probabilityOfAtLeastOneSuccess(baseProb, boostFactor);
    }

    public static void travellersWingsHighJump(LivingEntity livingEntity) {
        ItemStack leggingsStack = livingEntity.getItemBySlot(EquipmentSlot.LEGS);
        Integer amplifier = (Integer)leggingsStack.get(TFDataComponents.HIGH_JUMP_AMPLIFIER);
        if (TravellersModifiersManager.isModifierActive((Entity)livingEntity, leggingsStack, TravellersModifiersManager.HIGH_JUMP_ABILITY) && amplifier != null) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.JUMP, 2, amplifier.intValue(), false, false, false));
        }
    }

    public static void travellersVestHaste(LivingEntity livingEntity) {
        ItemStack chestStack = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
        Integer amplifier = (Integer)chestStack.get(TFDataComponents.HASTE_AMPLIFIER);
        if (TravellersModifiersManager.isModifierActive((Entity)livingEntity, chestStack, TravellersModifiersManager.HASTE_MODIFIER) && amplifier != null) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 2, amplifier.intValue(), false, false, false));
        }
    }

    public static void travellersBootsUnrestrained(LivingEntity livingEntity) {
        if (TravellersModifiersManager.isModifierActive(livingEntity, TravellersModifiersManager.UNRESTRAINED_MODIFIER)) {
            livingEntity.stuckSpeedMultiplier = Vec3.ZERO;
        }
    }

    public static boolean tryPerformSidestep(Player player, boolean isLeftSidestep) {
        long lastSidestepTime = (Long)player.getData(TFDataAttachments.LAST_SIDESTEP_TIME);
        ItemStack leggingsStack = player.getItemBySlot(EquipmentSlot.LEGS);
        Long cooldown = (Long)leggingsStack.get(TFDataComponents.SIDESTEP_COOLDOWN);
        long currentTime = player.level().getGameTime();
        if (TravellersModifiersManager.isModifierActive((Entity)player, leggingsStack, TravellersModifiersManager.SIDESTEP_MODIFIER) && cooldown != null && currentTime - lastSidestepTime > cooldown && !player.isFallFlying() && player.onGround() && !player.isCrouching()) {
            TravellersGearLogic.performSidestep(player, isLeftSidestep);
            player.setData(TFDataAttachments.LAST_SIDESTEP_TIME, (Object)currentTime);
            player.setData(TFDataAttachments.SHOULD_PLAY_SIDE_STEP_COOLDOWN_SOUND, (Object)true);
            return true;
        }
        return false;
    }

    public static void performSidestep(Player player, boolean isLeftSidestep) {
        float angle = player.getYRot();
        double rot = isLeftSidestep ? -1.5707963267948966 : 1.5707963267948966;
        Vec3 dashDirection = new Vec3(-Math.sin(Math.toRadians(angle) + rot), 0.0, Math.cos(Math.toRadians(angle) + rot));
        player.push(dashDirection.scale(1.6));
        player.playSound((SoundEvent)TFSounds.SIDE_STEP.get(), 1.0f, player.getVoicePitch());
    }

    public static boolean performDoubleJump(Player player) {
        Level level;
        boolean hasDoubleJump = (Boolean)player.getData(TFDataAttachments.HAS_DOUBLE_JUMP);
        if (!hasDoubleJump || player.isFallFlying() || player.onClimbable() || player.onGround() || player.isSwimming() || player.getAbilities().flying || player.isInLiquid()) {
            return false;
        }
        player.jumpFromGround();
        player.resetFallDistance();
        float pitchShift = 0.1f;
        player.playSound((SoundEvent)TFSounds.DOUBLE_JUMP.get(), 1.5f, (player.getVoicePitch() - 1.0f) * (1.0f + pitchShift) + (1.0f - pitchShift * 0.2f));
        player.setData(TFDataAttachments.HAS_DOUBLE_JUMP, (Object)false);
        player.setData(TFDataAttachments.DOUBLE_JUMP_VALIDATOR, (Object)0);
        AttributeInstance instance = player.getAttribute(Attributes.SAFE_FALL_DISTANCE);
        if (instance != null) {
            instance.addOrUpdateTransientModifier(TFAttributeModifiers.TRAVELLERS_DOUBLE_JUMP_SAFE_FALL_DISTANCE);
        }
        if ((level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player.getItemBySlot(EquipmentSlot.LEGS).is(TFItems.TRAVELLERS_WINGS)) {
                ParticlePacket particlePacket = new ParticlePacket();
                Vec3 deltaMovement = player.getDeltaMovement();
                for (int particleNumber = 0; particleNumber < 10; ++particleNumber) {
                    Vec3 particleVelocity = new Vec3(serverLevel.random.nextDouble() - 0.5, serverLevel.random.nextDouble() + 1.0, serverLevel.random.nextDouble() - 0.5);
                    ParticleOptions type = (ParticleOptions)TFParticleType.DOUBLE_JUMP.get();
                    Vec3 wingsPosition = player.position().add(Math.sin(Math.toRadians(player.yBodyRot)) / 3.0, 1.2, -Math.cos(Math.toRadians(player.yBodyRot)) / 3.0);
                    particlePacket.queueParticle(type, false, wingsPosition, particleVelocity.multiply(0.25, -0.5, 0.25).add(deltaMovement));
                }
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return true;
    }

    public static void travellersBootsSlimySolesBounce(LivingEntity livingEntity) {
        SlimySolesAttachment slimySolesAttachment = (SlimySolesAttachment)livingEntity.getData(TFDataAttachments.SLIMY_SOLES_BOUNCE_INFO);
        if (slimySolesAttachment.bounceVelocity == 0.0 || slimySolesAttachment.hasBounced) {
            return;
        }
        Vec3 velocity = livingEntity.getDeltaMovement();
        livingEntity.setDeltaMovement(velocity.x(), Math.sqrt(Math.pow(velocity.y(), 2.0) + Math.pow(slimySolesAttachment.bounceVelocity, 2.0)), velocity.z());
        livingEntity.playSound(SoundEvents.SLIME_JUMP, 0.5f, 1.0f);
        TravellersGearLogic.travellersBootsSlimySolesParticles(livingEntity, slimySolesAttachment);
        slimySolesAttachment.forceBounce = Math.abs(livingEntity.getDeltaMovement().y()) > 0.25;
        slimySolesAttachment.hasBounced = true;
    }

    public static void travellersBootsSlimySolesParticles(LivingEntity entity, SlimySolesAttachment attachment) {
        ServerLevel level;
        block5: {
            block4: {
                Level level2 = entity.level();
                if (!(level2 instanceof ServerLevel)) break block4;
                level = (ServerLevel)level2;
                if (!(attachment.bounceVelocity <= 0.0)) break block5;
            }
            return;
        }
        double particleX = entity.getX();
        double particleY = entity.getY();
        double particleZ = entity.getZ();
        double intensity = Math.min(0.2 + attachment.bounceVelocity, 2.5);
        int count = (int)(40.0 * intensity);
        if (count > 0) {
            level.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SLIME_BLOCK.defaultBlockState()), particleX, particleY, particleZ, count, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    private static void validateMovement(ServerPlayer serverPlayer, DeferredHolder<AttachmentType<?>, AttachmentType<Integer>> validator, DeferredHolder<AttachmentType<?>, AttachmentType<Integer>> lastCheck, String movementType) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null || !server.isDedicatedServer()) {
            return;
        }
        int count = (Integer)serverPlayer.getData(validator);
        int lastTick = (Integer)serverPlayer.getData(lastCheck);
        int currentTick = serverPlayer.tickCount;
        int diff = currentTick - lastTick;
        TwilightForestMod.LOGGER.debug("{} {} check: count={}, lastTick={}, currentTick={}, diff={}", (Object)serverPlayer.getName().getString(), (Object)movementType, (Object)count, (Object)lastTick, (Object)currentTick, (Object)diff);
        if (diff >= 45 && !serverPlayer.isFallFlying()) {
            count = -1;
        }
        serverPlayer.setData(lastCheck, (Object)currentTick);
        if (count >= 5) {
            serverPlayer.connection.disconnect(new DisconnectionDetails((Component)Component.translatable((String)"multiplayer.disconnect.flying")));
            return;
        }
        serverPlayer.setData(validator, (Object)(count + 1));
        if (count > 1) {
            TwilightForestMod.LOGGER.warn("{} illegal {}", (Object)serverPlayer.getName().getString(), (Object)movementType);
            serverPlayer.absMoveTo(serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), serverPlayer.getYRot(), serverPlayer.getXRot());
            serverPlayer.connection.send((Packet)new ClientboundPlayerPositionPacket(serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), serverPlayer.getYRot(), serverPlayer.getXRot(), Collections.emptySet(), 0));
        }
    }

    public static void handleSidestepAbuse(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TravellersGearLogic.validateMovement(serverPlayer, TFDataAttachments.SIDESTEP_VALIDATOR, TFDataAttachments.SIDESTEP_VALIDATOR_LAST_CHECK, "sidestep");
        }
    }

    public static void handleDoubleJumpAbuse(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TravellersGearLogic.validateMovement(serverPlayer, TFDataAttachments.DOUBLE_JUMP_VALIDATOR, TFDataAttachments.DOUBLE_JUMP_VALIDATOR_LAST_CHECK, "double jump");
        }
    }
}

