/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import twilightforest.TFRegistries;
import twilightforest.util.Enforcement;
import twilightforest.util.PlayerHelper;

public record Restriction(@Nullable ResourceKey<Structure> hintStructureKey, ResourceKey<Enforcement> enforcement, float multiplier, @Nullable ItemStack lockedBiomeToast, List<ResourceLocation> advancements) {
    public static final Codec<Restriction> CODEC = RecordCodecBuilder.create(recordCodecBuilder -> recordCodecBuilder.group((App)ResourceKey.codec((ResourceKey)Registries.STRUCTURE).optionalFieldOf("structure_key").forGetter(restriction -> Optional.ofNullable(restriction.hintStructureKey())), (App)ResourceKey.codec(TFRegistries.Keys.ENFORCEMENT).fieldOf("enforcement").forGetter(Restriction::enforcement), (App)Codec.FLOAT.fieldOf("multiplier").forGetter(Restriction::multiplier), (App)ItemStack.CODEC.optionalFieldOf("locked_biome_toast").forGetter(restriction -> Optional.ofNullable(restriction.lockedBiomeToast())), (App)ExtraCodecs.nonEmptyList((Codec)ResourceLocation.CODEC.listOf()).fieldOf("advancements").forGetter(Restriction::advancements)).apply((Applicative)recordCodecBuilder, Restriction::create));

    private static Restriction create(Optional<ResourceKey<Structure>> hintStructureKey, ResourceKey<Enforcement> enforcer, float multiplier, Optional<ItemStack> lockedBiomeToast, List<ResourceLocation> advancements) {
        return new Restriction((ResourceKey<Structure>)((ResourceKey)hintStructureKey.orElse(null)), enforcer, multiplier, lockedBiomeToast.orElse(null), advancements);
    }

    public static Optional<Restriction> getRestrictionForBiome(Biome biome, Entity entity) {
        if (!(entity instanceof Player)) {
            return Optional.empty();
        }
        Player player = (Player)entity;
        RegistryAccess access = entity.level().registryAccess();
        ResourceLocation biomeLocation = access.registryOrThrow(Registries.BIOME).getKey((Object)biome);
        if (biomeLocation == null) {
            return Optional.empty();
        }
        Optional restrictionsRegistry = access.registry(TFRegistries.Keys.RESTRICTIONS);
        if (restrictionsRegistry.isEmpty()) {
            return Optional.empty();
        }
        Restriction restrictions = (Restriction)((Registry)restrictionsRegistry.get()).get(biomeLocation);
        if (restrictions == null || PlayerHelper.doesPlayerHaveRequiredAdvancements(player, restrictions.advancements())) {
            return Optional.empty();
        }
        return Optional.of(restrictions);
    }

    public static boolean isBiomeSafeFor(Biome biome, Entity entity) {
        return Restriction.getRestrictionForBiome(biome, entity).isEmpty();
    }
}

