/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.icetower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.icetower.IceTowerBridgeComponent;
import twilightforest.world.components.structures.icetower.IceTowerDecorator;
import twilightforest.world.components.structures.icetower.IceTowerEntranceComponent;
import twilightforest.world.components.structures.icetower.IceTowerWingComponent;

public class IceTowerMainComponent
extends IceTowerWingComponent {
    public boolean hasBossWing = false;

    public IceTowerMainComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFITMai.get(), nbt);
        this.hasBossWing = nbt.getBoolean("hasBossWing");
    }

    public IceTowerMainComponent(RandomSource rand, int index, int x, int y, int z) {
        this(rand, index, x + 11, y + 40, z + 11, Direction.NORTH);
    }

    public IceTowerMainComponent(RandomSource rand, int index, int x, int y, int z, Direction rotation) {
        super((StructurePieceType)TFStructurePieceTypes.TFITMai.get(), index, x, y, z, 11, 31 + rand.nextInt(3) * 10, rotation);
        if (this.deco == null) {
            this.deco = new IceTowerDecorator();
        }
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.addAdditionalSaveData(ctx, tagCompound);
        tagCompound.putBoolean("hasBossWing", this.hasBossWing);
    }

    @Override
    public void addChildren(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        StructurePiecesBuilder start;
        if (list instanceof StructurePiecesBuilder) {
            start = (StructurePiecesBuilder)list;
        } else {
            return;
        }
        while (!((IceTowerMainComponent)parent).hasBossWing) {
            int length;
            rand.setSeed(rand.nextLong());
            this.openings.clear();
            this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
            start.pieces.clear();
            start.pieces.add(parent);
            BoundingBox towerBB = BoundingBoxUtils.clone(this.boundingBox);
            for (StructurePiece structurecomponent : start.pieces) {
                towerBB.encapsulate(structurecomponent.getBoundingBox());
            }
            BlockPos myDoor = (BlockPos)this.openings.get(0);
            BlockPos entranceDoor = new BlockPos((Vec3i)myDoor);
            if (myDoor.getX() == 0 && (length = 30 + rand.nextInt(20)) >= 0) {
                entranceDoor = entranceDoor.west(length);
                this.makeEntranceBridge(list, rand, this.getGenDepth() + 1, myDoor.getX(), myDoor.getY(), myDoor.getZ(), length, Rotation.CLOCKWISE_180);
            }
            if (myDoor.getX() == this.size - 1) {
                entranceDoor = entranceDoor.east(towerBB.maxX() - this.getBoundingBox().maxX());
            }
            if (myDoor.getZ() == 0) {
                entranceDoor = entranceDoor.south(towerBB.minZ() - this.getBoundingBox().minZ());
            }
            if (myDoor.getX() == this.size - 1) {
                entranceDoor = entranceDoor.south(towerBB.maxZ() - this.getBoundingBox().maxZ());
            }
            this.makeEntranceTower(list, rand, this.getGenDepth() + 1, entranceDoor.getX(), entranceDoor.getY(), entranceDoor.getZ(), 11, 11, this.rotation);
            super.addChildren(parent, (StructurePieceAccessor)start, rand);
        }
    }

    private void makeEntranceBridge(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int length, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        BlockPos dest = this.offsetTowerCCoords(x, y, z, 5, direction);
        IceTowerBridgeComponent bridge = new IceTowerBridgeComponent(index, dest.getX(), dest.getY(), dest.getZ(), length, 4, direction);
        list.addPiece((StructurePiece)bridge);
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            bridge.addChildren((StructurePiece)start.pieces.get(0), list, rand);
        }
    }

    public boolean makeEntranceTower(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        IceTowerEntranceComponent entrance = new IceTowerEntranceComponent(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.addPiece((StructurePiece)entrance);
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            ((IceTowerWingComponent)entrance).addChildren((StructurePiece)start.pieces.get(0), list, rand);
        }
        this.addOpening(x, y, z, rotation);
        return true;
    }
}

