/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFStructureTypes;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.structures.TwilightJigsawPiece;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureTemplateDefinitions;

public class CampStructure
extends Structure
implements DecorationClearance {
    public static final MapCodec<CampStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.settingsCodec((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, CampStructure::new));
    @Autowired
    private static StructureTemplateDefinitions structureTemplateDefinitions;

    protected CampStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom random = context.random();
        int blockXCenter = Mth.lerpDiscrete((float)random.nextFloat(), (int)chunkPos.getMinBlockX(), (int)chunkPos.getMaxBlockX());
        int blockZCenter = Mth.lerpDiscrete((float)random.nextFloat(), (int)chunkPos.getMinBlockZ(), (int)chunkPos.getMaxBlockZ());
        int topFreeY = WorldUtil.adjustForTerrain(context, blockXCenter, blockZCenter, 12, 3);
        BlockPos freePosition = new BlockPos(blockXCenter, topFreeY, blockZCenter);
        Direction direction = Rotation.getRandom((RandomSource)random).rotate(Direction.SOUTH);
        FrontAndTop oriented = FrontAndTop.fromFrontAndTop((Direction)Direction.UP, (Direction)direction);
        return Optional.of(new Structure.GenerationStub(freePosition, structurePiecesBuilder -> {
            ResourceLocation templatePool = TwilightForestMod.prefix("camp/structure_start");
            TwilightJigsawPiece twilightJigsawPiece = structureTemplateDefinitions.initializeTemplateFromPool(templatePool, freePosition, oriented, templatePool.toString(), context, 0, false);
            if (twilightJigsawPiece == null) {
                return;
            }
            structurePiecesBuilder.addPiece((StructurePiece)twilightJigsawPiece);
            twilightJigsawPiece.addJigsaws(twilightJigsawPiece, (StructurePieceAccessor)structurePiecesBuilder, context);
        }));
    }

    public StructureType<?> type() {
        return (StructureType)TFStructureTypes.CAMP.value();
    }

    public static CampStructure buildStructureConfig(BootstrapContext<Structure> context) {
        return new CampStructure(new Structure.StructureSettings((HolderSet)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_CAMP_BIOMES), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX));
    }

    @Override
    public float chunkClearanceRadius() {
        return 1.0f;
    }

    @Override
    public boolean isSurfaceDecorationsAllowed() {
        return false;
    }

    @Override
    public boolean isUndergroundDecoAllowed() {
        return true;
    }

    @Override
    public boolean isGrassDecoAllowed() {
        return true;
    }

    @Override
    public boolean shouldAdjustToTerrain() {
        return false;
    }
}

