/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import twilightforest.TFRegistries;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFMapDecorations;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.init.TFStructureTypes;
import twilightforest.init.custom.StructureSpeleothemConfigs;
import twilightforest.world.components.chunkgenerators.FocusedDensityFunction;
import twilightforest.world.components.chunkgenerators.HollowHillFunction;
import twilightforest.world.components.structures.CustomDensitySource;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.components.structures.StructureSpeleothemConfig;
import twilightforest.world.components.structures.util.ConfigurableSpawns;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.LandmarkStructure;

public class HollowHillStructure
extends LandmarkStructure
implements ConfigurableSpawns,
CustomDensitySource {
    public static final MapCodec<HollowHillStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)3).fieldOf("hill_size").forGetter(s -> s.size), (App)ControlledSpawns.ControlledSpawningConfig.CODEC.fieldOf("controlled_spawns").forGetter(s -> s.controlledSpawningConfig), (App)StructureSpeleothemConfigs.CODEC.fieldOf("speleothem_config").forGetter(s -> s.speleothemConfig)).and(HollowHillStructure.landmarkCodec(instance)).apply((Applicative)instance, HollowHillStructure::new));
    private final int size;
    private final ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig;
    private final Holder.Reference<StructureSpeleothemConfig> speleothemConfig;

    public HollowHillStructure(int size, ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, Holder<StructureSpeleothemConfig> speleothemConfig, Optional<DecorationClearance.DecorationConfig> decorationConfig, boolean centerInChunk, Optional<Holder<MapDecorationType>> structureIcon, Structure.StructureSettings structureSettings) {
        super(decorationConfig, centerInChunk, structureIcon, structureSettings);
        this.size = size;
        this.controlledSpawningConfig = controlledSpawningConfig;
        this.speleothemConfig = (Holder.Reference)speleothemConfig;
    }

    public boolean canSpawnMob(BlockPos spawnPos, BoundingBox structureStartBox) {
        float hZ;
        float hY;
        float hX = Mth.inverseLerp((float)spawnPos.getX(), (float)structureStartBox.minX(), (float)structureStartBox.maxX()) * 2.0f - 1.0f;
        return Mth.length((double)hX, (double)(hY = Mth.inverseLerp((float)spawnPos.getY(), (float)structureStartBox.minY(), (float)structureStartBox.maxY())), (double)(hZ = Mth.inverseLerp((float)spawnPos.getZ(), (float)structureStartBox.minZ(), (float)structureStartBox.maxZ()) * 2.0f - 1.0f)) < (double)0.975f;
    }

    @Override
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        return switch (this.size) {
            case 1 -> new HollowHillComponent((StructurePieceType)TFStructurePieceTypes.TFHill.get(), 0, this.size, x - 3, y - 2, z - 3, this.speleothemConfig);
            case 2 -> new HollowHillComponent((StructurePieceType)TFStructurePieceTypes.TFHill.get(), 0, this.size, x - 7, y - 5, z - 7, this.speleothemConfig);
            default -> new HollowHillComponent((StructurePieceType)TFStructurePieceTypes.TFHill.get(), 0, this.size, x - 11, y - 5, z - 11, this.speleothemConfig);
        };
    }

    public StructureType<?> type() {
        return (StructureType)TFStructureTypes.HOLLOW_HILL.get();
    }

    @Override
    public ControlledSpawns.ControlledSpawningConfig getConfig() {
        return this.controlledSpawningConfig;
    }

    public static HollowHillStructure buildSmallHillConfig(BootstrapContext<Structure> context) {
        return new HollowHillStructure(1, ControlledSpawns.ControlledSpawningConfig.create(List.of(List.of(new MobSpawnSettings.SpawnerData(EntityType.SPIDER, 10, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE, 10, 4, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP.get(), 10, 4, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SWARM_SPIDER.get(), 10, 4, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KOBOLD.get(), 10, 4, 8))), List.of(), List.of()), (Holder<StructureSpeleothemConfig>)context.lookup(TFRegistries.Keys.STRUCTURE_SPELEOTHEM_SETTINGS).getOrThrow(StructureSpeleothemConfigs.SMALL_HILL), Optional.of(new DecorationClearance.DecorationConfig(1.0f, true, false, false)), true, Optional.of(TFMapDecorations.SMALL_HOLLOW_HILL), new Structure.StructureSettings((HolderSet)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE));
    }

    public static HollowHillStructure buildMediumHillConfig(BootstrapContext<Structure> context) {
        return new HollowHillStructure(2, ControlledSpawns.ControlledSpawningConfig.create(List.of(List.of(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP_SAPPER.get(), 2, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KOBOLD.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 10, 2, 3), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SWARM_SPIDER.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.SPIDER, 10, 1, 3), new MobSpawnSettings.SpawnerData(EntityType.CREEPER, 5, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.FIRE_BEETLE.get(), 5, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SLIME_BEETLE.get(), 5, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.WITCH, 1, 1, 1))), List.of(), List.of()), (Holder<StructureSpeleothemConfig>)context.lookup(TFRegistries.Keys.STRUCTURE_SPELEOTHEM_SETTINGS).getOrThrow(StructureSpeleothemConfigs.MEDIUM_HILL), Optional.of(new DecorationClearance.DecorationConfig(2.0f, true, false, false)), true, Optional.of(TFMapDecorations.MEDIUM_HOLLOW_HILL), new Structure.StructureSettings((HolderSet)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE));
    }

    public static HollowHillStructure buildLargeHillConfig(BootstrapContext<Structure> context) {
        return new HollowHillStructure(3, ControlledSpawns.ControlledSpawningConfig.firstIndexMonsters(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.REDCAP_SAPPER.get(), 2, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 10, 2, 3), new MobSpawnSettings.SpawnerData(EntityType.CAVE_SPIDER, 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.CREEPER, 10, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 1, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.WRAITH.get(), 2, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.FIRE_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SLIME_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.PINCH_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.WITCH, 1, 1, 1)), (Holder<StructureSpeleothemConfig>)context.lookup(TFRegistries.Keys.STRUCTURE_SPELEOTHEM_SETTINGS).getOrThrow(StructureSpeleothemConfigs.LARGE_HILL), Optional.of(new DecorationClearance.DecorationConfig(3.0f, true, false, false)), true, Optional.of(TFMapDecorations.LARGE_HOLLOW_HILL), new Structure.StructureSettings((HolderSet)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE));
    }

    @Override
    public DensityFunction getStructureTerraformer(ChunkPos chunkSliceAt, StructureStart structurePieceSource) {
        int hillSize = this.size;
        float radius = ((float)(hillSize * 4) + 0.8f) * 8.0f;
        float radiusInner = radius - 8.0f;
        BoundingBox structureBox = structurePieceSource.getBoundingBox();
        int width = Math.min(structureBox.getXSpan(), structureBox.getZSpan());
        int yCeilingFocus = structureBox.minY();
        BlockPos hillCenter = structureBox.getCenter();
        DensityFunction hillMound = HollowHillFunction.fromPos(hillCenter.atY(yCeilingFocus + 10), radius, 0.7f).clamp(0.0, 1.0);
        DensityFunction innerCeiling = DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-1.0), (DensityFunction)HollowHillFunction.fromPos(hillCenter.atY(yCeilingFocus + 6), radiusInner, 0.675f));
        HollowHillFunction innerFloor = HollowHillFunction.fromPos(hillCenter.atY(yCeilingFocus + hillSize + hillSize / 2), 2.0f - radiusInner, 0.1f);
        DensityFunction interior = DensityFunctions.max((DensityFunction)innerCeiling, (DensityFunction)innerFloor);
        FocusedDensityFunction interiorMask = FocusedDensityFunction.fromPos(hillCenter.atY(yCeilingFocus), radiusInner * 0.52f, -radiusInner, 1.0f);
        DensityFunction interiorMasked = DensityFunctions.max((DensityFunction)interiorMask, (DensityFunction)interior);
        DensityFunction hollowHill = DensityFunctions.min((DensityFunction)hillMound, (DensityFunction)interiorMasked);
        DensityFunction maskingSphere = FocusedDensityFunction.fromPos(hillCenter.below(Mth.ceil((double)((double)radius * 0.1))), (float)width * 0.5f + 5.0f, (float)width * 0.25f, 0.0f).clamp(0.0, 1.0);
        return DensityFunctions.mul((DensityFunction)maskingSphere, (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)8.0), (DensityFunction)hollowHill));
    }
}

