/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFMapDecorations;
import twilightforest.init.TFStructureTypes;
import twilightforest.util.WorldUtil;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.world.components.chunkgenerators.BoxDensityFunction;
import twilightforest.world.components.structures.CustomDensitySource;
import twilightforest.world.components.structures.TwilightJigsawPiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerBaseTrim;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerFoyer;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerWingBeard;
import twilightforest.world.components.structures.lichtowerrevamp.LichYardBox;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ControlledSpawningStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class LichTowerStructure
extends ControlledSpawningStructure
implements CustomDensitySource {
    public static final MapCodec<LichTowerStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> LichTowerStructure.controlledSpawningCodec(instance).apply((Applicative)instance, LichTowerStructure::new));

    public LichTowerStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, Optional<StructureHints.HintConfig> hintConfig, Optional<DecorationClearance.DecorationConfig> decorationConfig, boolean centerInChunk, Optional<Holder<MapDecorationType>> structureIcon, Structure.StructureSettings structureSettings) {
        super(controlledSpawningConfig, advancementLockConfig, hintConfig, decorationConfig, centerInChunk, structureIcon, structureSettings);
    }

    @Override
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        FrontAndTop oriented;
        Direction direction = Rotation.getRandom((RandomSource)random).rotate(Direction.SOUTH);
        BlockPos placePos = new BlockPos(x, y, z).relative(direction, 24);
        JigsawPlaceContext placeContext = JigsawPlaceContext.pickPlaceableJunction(placePos, BlockPos.ZERO, oriented = FrontAndTop.fromFrontAndTop((Direction)Direction.UP, (Direction)direction), context.structureTemplateManager(), TwilightForestMod.prefix("lich_tower/tower_foyer"), "twilightforest:lich_tower/vestibule", random);
        return placeContext == null ? null : new LichTowerFoyer(context.structureTemplateManager(), placeContext, true, random.nextBoolean());
    }

    @Override
    protected void generateFromStartingPiece(StructurePiece startingPiece, Structure.GenerationContext context, StructurePiecesBuilder structurePiecesBuilder) {
        structurePiecesBuilder.addPiece(startingPiece);
        if (startingPiece instanceof TwilightJigsawPiece) {
            TwilightJigsawPiece jigsaw = (TwilightJigsawPiece)startingPiece;
            jigsaw.addJigsaws(jigsaw, (StructurePieceAccessor)structurePiecesBuilder, context);
        } else {
            startingPiece.addChildren(startingPiece, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)context.random());
        }
        if (startingPiece instanceof LichTowerFoyer) {
            LichTowerFoyer foyerPiece = (LichTowerFoyer)startingPiece;
            LichYardBox.beginYard(foyerPiece, context, structurePiecesBuilder);
        }
    }

    public StructureType<?> type() {
        return (StructureType)TFStructureTypes.LICH_TOWER.get();
    }

    public static LichTowerStructure buildLichTowerConfig(BootstrapContext<Structure> context) {
        List<MobSpawnSettings.SpawnerData> yardSpawns = List.of(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.RISING_ZOMBIE.value(), 2, 1, 2));
        List<MobSpawnSettings.SpawnerData> interiorSpawns = List.of(new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE, 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.CREEPER, 1, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 1, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.DEATH_TOME.value(), 10, 2, 3), new MobSpawnSettings.SpawnerData(EntityType.WITCH, 1, 1, 1));
        ControlledSpawns.ControlledSpawningConfig monsters = ControlledSpawns.ControlledSpawningConfig.justMonsters(yardSpawns, interiorSpawns);
        return new LichTowerStructure(monsters, new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_naga"))), Optional.of(new StructureHints.HintConfig(StructureHints.HintConfig.book("lichtower", 4), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get()))), Optional.of(new DecorationClearance.DecorationConfig(0.0f, false, true, false, true)), true, Optional.of(TFMapDecorations.LICH_TOWER), new Structure.StructureSettings((HolderSet)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_LICH_TOWER_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN));
    }

    @Override
    public DensityFunction getStructureTerraformer(ChunkPos chunkPosAt, StructureStart structurePieceSource) {
        ArrayList<BoundingBox> trimBoxes = new ArrayList<BoundingBox>();
        int yBase = ((StructurePiece)structurePieceSource.getPieces().getFirst()).getBoundingBox().minY();
        DensityFunction activator = DensityFunctions.yClampedGradient((int)(yBase - 2), (int)(yBase - 1), (double)1.0, (double)0.0);
        for (StructurePiece piece : structurePieceSource.getPieces()) {
            LichYardBox yard;
            LichTowerWingBeard beard;
            if (piece instanceof LichTowerFoyer || piece instanceof LichTowerBaseTrim || piece instanceof LichTowerWingBeard && (beard = (LichTowerWingBeard)piece).isTrim()) {
                trimBoxes.add(piece.getBoundingBox());
                continue;
            }
            if (!(piece instanceof LichYardBox) || (yard = (LichYardBox)piece).getTerrainAdjustment() == TerrainAdjustment.NONE) continue;
            trimBoxes.add(piece.getBoundingBox().moved(0, -5, 0));
        }
        return DensityFunctions.mul((DensityFunction)activator, (DensityFunction)BoxDensityFunction.combine(trimBoxes, -5, -5, TerrainAdjustment.BURY));
    }

    @Override
    public int adjustForTerrain(Structure.GenerationContext context, int x, int z) {
        return WorldUtil.adjustForTerrain(context, x, z, 32, 4);
    }
}

