/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import twilightforest.TwilightForestMod;

public abstract class CodecResourceReloadListener<T>
extends SimpleJsonResourceReloadListener {
    protected final Gson gson;
    private final Codec<T> codec;

    public CodecResourceReloadListener(String directory, Codec<T> codec) {
        this(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), directory, codec);
    }

    public CodecResourceReloadListener(Gson gson, String directory, Codec<T> codec) {
        super(gson, directory);
        this.gson = gson;
        this.codec = codec;
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        JsonElement jsonElement;
        ResourceLocation location;
        ArrayList<Map.Entry<ResourceLocation, JsonElement>> nonTwilight = new ArrayList<Map.Entry<ResourceLocation, JsonElement>>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            location = entry.getKey();
            if (location.getPath().contains("entries")) continue;
            if ("twilightforest".equals(location.getNamespace())) {
                jsonElement = entry.getValue();
                this.deserialize(manager, this.initDynamicOps(), location, jsonElement);
                continue;
            }
            nonTwilight.add(entry);
        }
        for (Map.Entry<Object, Object> entry : nonTwilight) {
            location = (ResourceLocation)entry.getKey();
            jsonElement = (JsonElement)entry.getValue();
            this.deserialize(manager, this.initDynamicOps(), location, jsonElement);
        }
    }

    protected void deserialize(ResourceManager manager, DynamicOps<JsonElement> ops, ResourceLocation location, JsonElement jsonElement) {
        try {
            Optional checkFile = this.codec.parse(ops, (Object)jsonElement).result();
            if (checkFile.isPresent()) {
                this.forLocation(manager, location, checkFile.get());
            } else {
                TwilightForestMod.LOGGER.error("Listener '{}' failed to load resource {}", (Object)this.getName(), (Object)location);
            }
        }
        catch (Exception e) {
            TwilightForestMod.LOGGER.error("Listener '{}' couldn't read element {}", (Object)this.getName(), (Object)location, (Object)e);
        }
    }

    protected DynamicOps<JsonElement> initDynamicOps() {
        return JsonOps.INSTANCE;
    }

    protected abstract void forLocation(ResourceManager var1, ResourceLocation var2, T var3);

    public void registerListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
    }
}

