/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block.entity;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidHopperBlockEntity
extends BlockEntity {
    int tick = 0;
    public IFluidHandler internalTank = new FluidTank(1000, p -> true);

    public FluidHopperBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)UtilityBlockModule.FLUID_HOPPER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public static <E extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, FluidHopperBlockEntity blockEntity) {
        if (((Boolean)blockState.getValue((Property)BlockStateProperties.ENABLED)).booleanValue() && ++blockEntity.tick >= (Integer)Config.FLUID_HOPPER_TICK_RATE.get()) {
            Optional handler;
            blockEntity.tick = 0;
            boolean hasInserted = false;
            FluidStack internalFluid = blockEntity.internalTank.getFluidInTank(0);
            boolean hasSpaceForBucket = internalFluid.getAmount() == 0;
            BlockState blockStateAbove = level.getBlockState(blockPos.above());
            if (hasSpaceForBucket && blockStateAbove.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)blockStateAbove.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                level.setBlockAndUpdate(blockPos.above(), (BlockState)blockStateAbove.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                blockEntity.internalTank.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                hasInserted = true;
            }
            if (!hasInserted) {
                FluidState fluidStateAbove = level.getFluidState(blockPos.above());
                if (hasSpaceForBucket && !fluidStateAbove.is(Fluids.EMPTY) && fluidStateAbove.isSource() && (internalFluid.isEmpty() || fluidStateAbove.isSourceOfType(internalFluid.getFluid()))) {
                    level.setBlockAndUpdate(blockPos.above(), Blocks.AIR.defaultBlockState());
                    blockEntity.internalTank.fill(new FluidStack(fluidStateAbove.getType(), 1000), IFluidHandler.FluidAction.EXECUTE);
                    hasInserted = true;
                }
            }
            if (!hasInserted && (handler = FluidUtil.getFluidHandler((Level)level, (BlockPos)blockPos.above(), (Direction)Direction.DOWN)).isPresent()) {
                handler.ifPresent(iFluidHandler -> {
                    if (internalFluid.isEmpty() || internalFluid.equals(iFluidHandler.getFluidInTank(0))) {
                        FluidUtil.tryFluidTransfer((IFluidHandler)blockEntity.internalTank, (IFluidHandler)iFluidHandler, (int)1000, (boolean)true);
                    }
                });
                hasInserted = true;
            }
            if (!hasInserted && blockStateAbove.is(BlockTags.CAULDRONS)) {
                FlowingFluid cauldronFluid;
                Object object = blockStateAbove.is(Blocks.WATER_CAULDRON) ? Fluids.WATER : (cauldronFluid = blockStateAbove.is(Blocks.LAVA_CAULDRON) ? Fluids.LAVA : Fluids.EMPTY);
                if (!cauldronFluid.isSame(Fluids.EMPTY) && hasSpaceForBucket) {
                    level.setBlockAndUpdate(blockPos.above(), Blocks.CAULDRON.defaultBlockState());
                    blockEntity.internalTank.fill(new FluidStack((Fluid)cauldronFluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                }
            }
            Direction direction = (Direction)blockState.getValue((Property)HopperBlock.FACING);
            Optional facingHandler = FluidUtil.getFluidHandler((Level)level, (BlockPos)blockPos.relative(direction), (Direction)direction.getOpposite());
            facingHandler.ifPresent(iFluidHandler -> FluidUtil.tryFluidTransfer((IFluidHandler)iFluidHandler, (IFluidHandler)blockEntity.internalTank, (int)Math.min(blockEntity.internalTank.getFluidInTank(0).getAmount(), 1000), (boolean)true));
        }
    }
}

