/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util.loot.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.drex.villagerconfig.common.util.loot.LootItemFunctionTypes;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class SetDyeFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetDyeFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetDyeFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)DyeColor.CODEC.listOf().optionalFieldOf("dye_colors").forGetter(setDyeFunction -> setDyeFunction.dyeColors), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(setDyeFunction -> setDyeFunction.add))).apply((Applicative)instance, SetDyeFunction::new));
    private final Optional<List<DyeColor>> dyeColors;
    private final boolean add;

    protected SetDyeFunction(List<LootItemCondition> conditions, Optional<List<DyeColor>> dyeColors, boolean add) {
        super(conditions);
        this.dyeColors = dyeColors;
        this.add = add;
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack stack, @NotNull LootContext context) {
        if (!stack.is(ItemTags.DYEABLE)) {
            return stack;
        }
        if (!this.add) {
            stack.set(DataComponents.DYED_COLOR, null);
        }
        List<DyeColor> colors = this.dyeColors.orElse((List<DyeColor>)ImmutableList.copyOf((Object[])DyeColor.values()));
        DyeColor color = colors.get(context.getRandom().nextInt(colors.size()));
        return DyedItemColor.applyDyes((ItemStack)stack, Collections.singletonList(DyeItem.byColor((DyeColor)color)));
    }

    @NotNull
    public LootItemFunctionType getType() {
        return LootItemFunctionTypes.SET_DYE;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Set<DyeColor> dyeColors = Sets.newHashSet();
        private final boolean add;

        public Builder() {
            this(false);
        }

        public Builder(boolean add) {
            this.add = add;
        }

        @NotNull
        protected Builder getThis() {
            return this;
        }

        public Builder add(DyeColor dyeColor) {
            this.dyeColors.add(dyeColor);
            return this;
        }

        @NotNull
        public SetDyeFunction build() {
            return new SetDyeFunction(this.getConditions(), this.dyeColors.isEmpty() ? Optional.empty() : Optional.of(ImmutableList.copyOf(this.dyeColors)), this.add);
        }
    }
}

