/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases;

import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectable;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import terrails.xnetgases.module.ChemicalHelper;
import terrails.xnetgases.module.chemical.ChemicalChannelType;
import terrails.xnetgases.module.logic.ChemicalLogicChannelType;

@Mod(value="xnetgases")
public class XNetGases {
    public static final String MOD_ID = "xnetgases";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ModConfigSpec.IntValue maxRateNormal;
    public static final ModConfigSpec.IntValue maxRateAdvanced;
    private static final ModConfigSpec CONFIG_SPEC;

    public XNetGases(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::setup);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CONFIG_SPEC, "xnetgases.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        InterModComms.sendTo((String)"xnet", (String)"getXNet", () -> api -> {
            api.registerChannelType(ChemicalChannelType.TYPE);
            api.registerChannelType((IChannelType)ChemicalLogicChannelType.TYPE);
            api.registerConnectable((blockGetter, connectorPos, blockPos, blockEntity, direction) -> {
                if (ChemicalHelper.blockSupportsChemicals(blockEntity, direction)) {
                    return IConnectable.ConnectResult.YES;
                }
                return IConnectable.ConnectResult.DEFAULT;
            });
            return null;
        });
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("General settings").push("general");
        maxRateNormal = builder.comment("Maximum chemical per operation that a normal connector can input or output").defineInRange("maxChemicalRateNormal", 1000, 1, 1000000000);
        maxRateAdvanced = builder.comment("Maximum chemical per operation that an advanced connector can input or output").defineInRange("maxChemicalRateAdvanced", 5000, 1, 1000000000);
        CONFIG_SPEC = builder.pop().build();
    }
}

