/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.api.xnet.tiles.IConnectorTile;
import mcjty.xnet.apiimpl.ConnectedEntity;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.setup.Config;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import terrails.xnetgases.Constants;
import terrails.xnetgases.module.chemical.ChemicalChannelType;
import terrails.xnetgases.module.chemical.ChemicalConnectorSettings;
import terrails.xnetgases.module.chemical.enums.ChannelMode;
import terrails.xnetgases.module.chemical.enums.ConnectorMode;

public class ChemicalChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final MapCodec<ChemicalChannelSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChannelMode.CODEC.fieldOf("mode").forGetter(ChemicalChannelSettings::getChannelMode)).apply((Applicative)instance, ChemicalChannelSettings::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalChannelSettings> STREAM_CODEC = StreamCodec.composite(ChannelMode.STREAM_CODEC, ChemicalChannelSettings::getChannelMode, ChemicalChannelSettings::new);
    private ChannelMode channelMode = ChannelMode.DISTRIBUTE;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private List<ConnectedEntity<ChemicalConnectorSettings>> extractors;
    private List<ConnectedEntity<ChemicalConnectorSettings>> consumers;

    public ChemicalChannelSettings() {
    }

    public ChemicalChannelSettings(ChannelMode channelMode) {
        this.channelMode = channelMode;
    }

    public ChannelMode getChannelMode() {
        return this.channelMode;
    }

    public IChannelType getType() {
        return ChemicalChannelType.TYPE;
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putInt("delay", this.delay);
        tag.putInt("distribute_offset", this.roundRobinOffset);
    }

    public void readFromNBT(CompoundTag tag) {
        this.delay = tag.getInt("delay");
        this.roundRobinOffset = tag.getInt("distribute_offset");
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add("mode", (JsonElement)new JsonPrimitive(this.channelMode.name()));
        return object;
    }

    public void readFromJson(JsonObject data) {
        this.channelMode = ChannelMode.byName(data.get("mode").getAsString());
    }

    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 != 0) {
            return;
        }
        this.updateCache(channel, context);
        Level level = context.getControllerWorld();
        for (ConnectedEntity<ChemicalConnectorSettings> extractor : this.extractors) {
            IChemicalHandler handler;
            ChemicalConnectorSettings settings = (ChemicalConnectorSettings)((Object)extractor.settings());
            ConnectorTileEntity connectorEntity = extractor.getConnectorEntity();
            if (this.delay % settings.getOperationSpeed() != 0 || !LevelTools.isLoaded((Level)level, (BlockPos)extractor.getBlockPos()) || !this.checkRedstone(settings, (IConnectorTile)extractor.getConnectorEntity(), context) || (handler = (IChemicalHandler)level.getCapability(Capabilities.CHEMICAL.block(), extractor.getBlockPos(), null, extractor.getConnectedEntity(), (Object)settings.getFacing())) == null) continue;
            this.tickChemicalHandler(context, settings, (BlockEntity)connectorEntity, handler);
        }
    }

    private void tickChemicalHandler(IControllerContext context, ChemicalConnectorSettings settings, BlockEntity connectorEntity, IChemicalHandler handler) {
        block5: {
            ChemicalStack extracted;
            long remaining;
            if (!context.checkAndConsumeRF(((Integer)Config.controllerChannelRFT.get()).intValue())) {
                return;
            }
            long amount = settings.getMatcher().amountInTank(handler, settings.getFacing());
            if (amount <= 0L) {
                return;
            }
            long toExtract = settings.getTransferRate(connectorEntity).intValue();
            Integer count = settings.getMinMaxLimit();
            if (count != null) {
                long canExtract = amount - (long)count.intValue();
                if (canExtract <= 0L) {
                    return;
                }
                toExtract = Math.min(toExtract, canExtract);
            }
            do {
                extracted = handler.extractChemical(toExtract, Action.SIMULATE);
                if (!settings.getMatcher().test(extracted)) break block5;
                toExtract = extracted.getAmount();
            } while ((remaining = this.insertChemical(context, extracted)) == (toExtract -= remaining));
            handler.extractChemical(toExtract, Action.EXECUTE);
        }
    }

    private long insertChemical(IControllerContext context, ChemicalStack stack) {
        Level level = context.getControllerWorld();
        if (this.channelMode == ChannelMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        long amount = stack.getAmount();
        int currentRoundRobinOffset = this.roundRobinOffset;
        for (int j = 0; j < this.consumers.size(); ++j) {
            IChemicalHandler handler;
            int i = (j + currentRoundRobinOffset) % this.consumers.size();
            ConnectedEntity<ChemicalConnectorSettings> consumer = this.consumers.get(i);
            ChemicalConnectorSettings settings = (ChemicalConnectorSettings)((Object)consumer.settings());
            ConnectorTileEntity connectorEntity = consumer.getConnectorEntity();
            if (!settings.getMatcher().test(stack) || !LevelTools.isLoaded((Level)level, (BlockPos)consumer.getBlockPos()) || !this.checkRedstone(settings, (IConnectorTile)consumer.getConnectorEntity(), context) || (handler = (IChemicalHandler)level.getCapability(Capabilities.CHEMICAL.block(), consumer.getBlockPos(), null, consumer.getConnectedEntity(), (Object)settings.getFacing())) == null) continue;
            long toInsert = Math.min((long)settings.getTransferRate((BlockEntity)connectorEntity).intValue(), amount);
            Integer count = settings.getMinMaxLimit();
            if (count != null) {
                long tankAmount = settings.getMatcher().amountInTank(handler, settings.getFacing());
                long canInsert = (long)count.intValue() - tankAmount;
                if (canInsert <= 0L) continue;
                toInsert = Math.min(toInsert, canInsert);
            }
            if (settings.isTransferRateRequired() && (long)settings.getTransferRate((BlockEntity)connectorEntity).intValue() > toInsert) continue;
            ChemicalStack copy = stack.copy();
            copy.setAmount(toInsert);
            ChemicalStack remaining = handler.insertChemical(copy, Action.EXECUTE);
            if (!remaining.isEmpty() && copy.getAmount() == remaining.getAmount()) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.consumers.size();
            if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
            return 0L;
        }
        return amount;
    }

    public void cleanCache() {
        this.extractors = null;
        this.consumers = null;
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.extractors == null) {
            ConnectedEntity<ChemicalConnectorSettings> connectedEntity;
            ChemicalConnectorSettings settings;
            this.extractors = new ArrayList<ConnectedEntity<ChemicalConnectorSettings>>();
            this.consumers = new ArrayList<ConnectedEntity<ChemicalConnectorSettings>>();
            Level level = context.getControllerWorld();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                connectedEntity = this.getConnectedEntityInfo(context, entry, level, settings = (ChemicalConnectorSettings)((Object)entry.getValue()));
                if (connectedEntity == null) continue;
                if (settings.getConnectorMode() == ConnectorMode.INS) {
                    this.consumers.add(connectedEntity);
                    continue;
                }
                this.extractors.add(connectedEntity);
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                settings = (ChemicalConnectorSettings)((Object)entry.getValue());
                if (settings.getConnectorMode() == ConnectorMode.EXT || (connectedEntity = this.getConnectedEntityInfo(context, entry, level, settings)) == null) continue;
                this.consumers.add(connectedEntity);
            }
            this.consumers.sort(Collections.reverseOrder(Comparator.comparing(o -> ((ChemicalConnectorSettings)((Object)((Object)((Object)o.settings())))).getPriority())));
        }
    }

    private ConnectedEntity<ChemicalConnectorSettings> getConnectedEntityInfo(IControllerContext context, Map.Entry<SidedConsumer, IConnectorSettings> entry, @Nonnull Level level, @Nonnull ChemicalConnectorSettings settings) {
        BlockPos connectorPos = context.findConsumerPosition(entry.getKey().consumerId());
        if (connectorPos == null) {
            return null;
        }
        ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)level.getBlockEntity(connectorPos);
        if (connectorTileEntity == null) {
            return null;
        }
        BlockPos connectedBlockPos = connectorPos.relative(entry.getKey().side());
        BlockEntity connectedEntity = level.getBlockEntity(connectedBlockPos);
        if (connectedEntity == null) {
            return null;
        }
        return new ConnectedEntity(entry.getKey(), (Object)settings, connectorPos, connectedBlockPos, connectedEntity, connectorTileEntity);
    }

    public int getColors() {
        return 0;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 90, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String s) {
        return true;
    }

    public void createGui(IEditorGui gui) {
        gui.nl().translatableChoices("mode", (ITranslatableEnum)this.channelMode, (ITranslatableEnum[])ChannelMode.values());
    }

    public void update(Map<String, Object> map) {
        Object value = map.get("mode");
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            this.channelMode = ChannelMode.values()[i];
        } else {
            this.channelMode = ChannelMode.DISTRIBUTE;
        }
    }
}

