/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.slf4j.Logger;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.items.IHandleCreativeTab;
import tv.soaryn.xycraft.core.content.registries.IRegister;
import tv.soaryn.xycraft.core.utils.StreamUtils;

public abstract class XyCraft {
    public static boolean IS_FORGECRAFT = true;
    public static final Logger Logger = LogUtils.getLogger();
    public static final String IssueTrackerURL = "https://github.com/Soaryn/XyCraftTracker/issues";
    public static final String ModId = "xycraft";
    protected final ModLoadingContext context = ModLoadingContext.get();

    public XyCraft(IEventBus bus, IRegister ... registers) {
        for (IRegister register : registers) {
            register.register(bus);
            register.register(this.context);
        }
        StreamUtils.setup(this);
    }

    public static ResourceLocation resource(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)ModId, (String)name);
    }

    protected void addToCreativeTabs(BuildCreativeModeTabContentsEvent event, ContentMap map) {
        IContent[] itemsInTab;
        for (IContent content2 : itemsInTab = (IContent[])map.MappedContent.stream().filter(content -> content.tab() != null && content.tab().isBound() && content.tab().get() == event.getTab()).toArray(IContent[]::new)) {
            if (!content2.hasPrerequisites() || !(content2 instanceof ItemLike)) continue;
            ItemLike itemLike = (ItemLike)content2;
            event.accept(itemLike);
        }
        map.MappedContent.stream().filter(iContent -> iContent instanceof ItemContent).map(ItemContent.class::cast).map(ItemContent::item).filter(IHandleCreativeTab.class::isInstance).map(IHandleCreativeTab.class::cast).forEach(iHandleCreativeTab -> iHandleCreativeTab.handle(event));
    }
}

