/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container;

import net.minecraft.core.NonNullList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.container.resource.ResourceListContainer;
import tv.soaryn.xycraft.core.utils.protocontainer.FluidResource;

public class SimpleResourceFluidContainer
extends ResourceListContainer<FluidResource> {
    private final int _capacity;

    public SimpleResourceFluidContainer(NonNullList<MutableResourceStack<FluidResource>> mutableResourceStacks, int capacity, @Nullable Runnable updateCallback) {
        super(mutableResourceStacks, updateCallback, MutableResourceStack.Empty.FLUID);
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than 0");
        }
        this._capacity = capacity;
    }

    public static SimpleResourceFluidContainer of(int size) {
        return SimpleResourceFluidContainer.of(size, 1000, null);
    }

    public static SimpleResourceFluidContainer of(int size, int capacity, @Nullable Runnable updateCallback) {
        return new SimpleResourceFluidContainer(MutableResourceStack.Empty.FLUID.nonNullListOfSize(size), capacity, updateCallback);
    }

    public static SimpleResourceFluidContainer from(NonNullList<MutableResourceStack<FluidResource>> resourceStacks, int capacity) {
        return SimpleResourceFluidContainer.from(resourceStacks, capacity, null);
    }

    public static SimpleResourceFluidContainer from(NonNullList<MutableResourceStack<FluidResource>> resourceStacks, int capacity, Runnable updateCallback) {
        SimpleResourceFluidContainer container = SimpleResourceFluidContainer.of(resourceStacks.size(), capacity, updateCallback);
        for (int i = 0; i < resourceStacks.size(); ++i) {
            container.set(i, (MutableResourceStack)resourceStacks.get(i));
        }
        return container;
    }

    public int getCapacity() {
        return this._capacity;
    }

    @Override
    public int getCapacity(int index) {
        return this.getCapacity();
    }

    @Override
    public int getCapacity(int index, @NotNull FluidResource resource) {
        return this.getCapacity(index);
    }
}

