/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.level.xynergy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultListenableGraph;
import org.jgrapht.graph.SimpleGraph;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNode;
import tv.soaryn.xycraft.core.content.attachments.level.xynergy.Xynergy;
import tv.soaryn.xycraft.core.content.attachments.level.xynergy.XynergyGraphEdge;
import tv.soaryn.xycraft.core.content.attachments.level.xynergy.XynergyGraphNode;
import tv.soaryn.xycraft.core.content.attachments.level.xynergy.XynergyGraphState;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public class XynergyGraph {
    public static final Codec<XynergyGraph> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)UUIDUtil.CODEC.fieldOf("id").forGetter(data -> data.Id), (App)NeoForgeExtraCodecs.setOf((Codec)Codec.LONG).fieldOf("vertices").forGetter(data -> data.Graph.vertexSet()), (App)NeoForgeExtraCodecs.setOf(XynergyGraphEdge.CODEC).fieldOf("edges").forGetter(data -> data.Graph.edgeSet()), (App)CodecUtils.tupleOf(Codec.LONG, XynergyGraphNode.CODEC, Long2ObjectOpenHashMap::new).fieldOf("nodes").forGetter(data -> data.NodeCache), (App)Xynergy.CODEC.fieldOf("xynergy").forGetter(data -> data.Power), (App)XynergyGraphState.CODEC.fieldOf("state").forGetter(data -> data.State)).apply((Applicative)builder, XynergyGraph::new));
    public final UUID Id;
    public final ListenableGraph<Long, XynergyGraphEdge> Graph = new DefaultListenableGraph((Graph)new SimpleGraph(XynergyGraphEdge.class));
    public final Xynergy Power;
    public XynergyGraphState State;
    public final Long2ObjectOpenHashMap<XynergyGraphNode> NodeCache = new Long2ObjectOpenHashMap();
    public final transient ConnectivityInspector<Long, XynergyGraphEdge> Inspector;
    protected transient LongSet dirtyNodes = new LongArraySet();
    private final LongSet _handledNodes = new LongArraySet();

    public XynergyGraph(ServerLevel serverLevel) {
        this(UUID.randomUUID(), Set.of(), Set.of(), (Long2ObjectOpenHashMap<XynergyGraphNode>)new Long2ObjectOpenHashMap(), new Xynergy(), XynergyGraphState.Invalid);
        this.load(serverLevel);
    }

    public XynergyGraph(UUID id, Set<Long> nodes, Set<XynergyGraphEdge> edges, Long2ObjectOpenHashMap<XynergyGraphNode> nodeCaches, Xynergy value, XynergyGraphState state) {
        this.Id = id;
        this.State = state;
        this.Power = value;
        this.Inspector = new ConnectivityInspector(this.Graph);
        this.Graph.addGraphListener(this.Inspector);
        this.Inspector.connectedSets();
        nodes.forEach(arg_0 -> this.Graph.addVertex(arg_0));
        edges.forEach(edgeData -> this.Graph.addEdge((Object)edgeData.src(), (Object)edgeData.dst(), edgeData));
        this.NodeCache.putAll(nodeCaches);
    }

    public void load(ServerLevel serverLevel) {
        for (Long2ObjectMap.Entry entry : this.NodeCache.long2ObjectEntrySet()) {
            XynergyGraphNode nodeCache = (XynergyGraphNode)entry.getValue();
            long posId = entry.getLongKey();
            nodeCache.getCachedCapability(serverLevel, posId, BlockPos.of((long)posId), this);
        }
    }

    public boolean isConnected() {
        return this.Inspector.isConnected();
    }

    public void addNode(ServerLevel level, long posId) {
        this.Graph.addVertex((Object)posId);
        XynergyGraphNode node = new XynergyGraphNode(level, posId, this);
        if (node.Type == null) {
            this.dirtyNodes.add(posId);
        } else if (node.Value > 0L) {
            this.Power.Supply += node.Value;
        } else if (node.Value < 0L) {
            this.Power.Demand += node.Value;
        }
        this.NodeCache.put(posId, (Object)node);
    }

    public void addEdge(long from, long to) {
        this.Graph.addEdge((Object)from, (Object)to, (Object)new XynergyGraphEdge(from, to));
    }

    public void removeEdge(long from, long to) {
        this.Graph.removeEdge((Object)from, (Object)to);
    }

    public void removeNode(long posId) {
        this.Graph.removeVertex((Object)posId);
    }

    public long calculateSum() {
        long sum = 0L;
        for (XynergyGraphNode node : this.NodeCache.values()) {
            sum = MathUtils.longSum(sum, node.Value);
        }
        return Math.clamp(sum, -1000000000000000000L, 1000000000000000000L);
    }

    public void clean(ServerLevel level) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (long posId : this.dirtyNodes.toLongArray()) {
            IXynergyNode cap;
            pos.set(posId);
            if (!level.shouldTickBlocksAt((BlockPos)pos)) continue;
            XynergyGraphNode nodeCache = (XynergyGraphNode)this.NodeCache.get(posId);
            this._handledNodes.add(posId);
            if (nodeCache == null || (cap = nodeCache.getCachedCapability(level, posId, (BlockPos)pos, this)) == null) continue;
            long l = cap.getValue();
        }
        this.dirtyNodes.removeAll((LongCollection)this._handledNodes);
        this._handledNodes.clear();
    }
}

