/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.handlers;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;

public record VoidItemHandler(BlockEntity voidContainer) implements IItemHandler
{
    public static final VoidItemHandler INSTANCE = new VoidItemHandler(null);

    public int getSlots() {
        return 64;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!simulate && this.voidContainer != null) {
            this.voidContainer.setData(CoreAttachments.Void, (Object)true);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }
}

