/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.items;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.content.registries.CoreItemDataComponents;

public class FoilItemModel
implements IUnbakedGeometry<FoilItemModel> {
    @NotNull
    private final FluidStack _fluidStack;
    private static final Transformation FluidTransforms = new Transformation(new Vector3f(), new Quaternionf().identity(), new Vector3f(1.0f, 1.0f, 0.75f), new Quaternionf().identity());
    private static final IQuadTransformer LightMapTransformer = QuadTransformers.applyingLightmap((int)0xF000F0);

    public FoilItemModel(@NotNull FluidStack fluidStack) {
        this._fluidStack = fluidStack;
    }

    @NotNull
    public BakedModel bake(@NotNull IGeometryBakingContext context, @NotNull ModelBaker baker, @NotNull Function<Material, TextureAtlasSprite> spriteGetter, @NotNull ModelState modelState, @NotNull ItemOverrides overrides) {
        TextureAtlasSprite maskSprite;
        Material fluidMaskLocation = context.hasMaterial("mask") ? context.getMaterial("mask") : null;
        Material baseLocations = context.hasMaterial("albedo") ? context.getMaterial("albedo") : null;
        Fluid fluid = this._fluidStack.getFluid();
        ResourceLocation fluidTexture = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(this._fluidStack);
        TextureAtlasSprite fluidSprite = fluidTexture != null && !this._fluidStack.isEmpty() ? spriteGetter.apply(ClientHooks.getBlockMaterial((ResourceLocation)fluidTexture)) : null;
        TextureAtlasSprite particleSprite = fluidSprite != null ? fluidSprite : spriteGetter.apply(baseLocations);
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(XyCraft.resource((String)"foil_item_overrides"));
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new FluidOverrideHandler(baker, (IGeometryBakingContext)itemContext), (ItemTransforms)context.getTransforms());
        RenderTypeGroup renderTypes = FoilItemModel.getLayerRenderTypes();
        if (fluidMaskLocation != null && fluidSprite != null && (maskSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.getRotation().compose(FluidTransforms), modelState.isUvLocked());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (TextureAtlasSprite)maskSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (ModelState)transformedState);
            if (fluid.getFluidType().getLightLevel() > 0) {
                LightMapTransformer.processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        if (baseLocations != null) {
            TextureAtlasSprite frameSprite = spriteGetter.apply(baseLocations);
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)1, (TextureAtlasSprite)frameSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> frameSprite, (ModelState)modelState);
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    public static RenderTypeGroup getLayerRenderTypes() {
        return new RenderTypeGroup(RenderType.cutout(), NeoForgeRenderTypes.ITEM_LAYERED_CUTOUT.get());
    }

    private static final class FluidOverrideHandler
    extends ItemOverrides {
        private final Int2ObjectMap<BakedModel> cache = new Int2ObjectOpenHashMap();
        private final ModelBaker _modelBaker;
        private final IGeometryBakingContext _bakingContext;

        private FluidOverrideHandler(ModelBaker baker, IGeometryBakingContext owner) {
            this._modelBaker = baker;
            this._bakingContext = owner;
        }

        public BakedModel resolve(@NotNull BakedModel originalModel, @NotNull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            SimpleFluidContent data = (SimpleFluidContent)stack.getOrDefault((Supplier)CoreItemDataComponents.FluidContainer, (Object)SimpleFluidContent.EMPTY);
            FluidStack fluidStack = data.copy();
            int hash = FluidStack.hashFluidAndComponents((FluidStack)fluidStack);
            if (!this.cache.containsKey(hash)) {
                FoilItemModel unbaked = new FoilItemModel(fluidStack);
                BakedModel bakedModel = unbaked.bake(this._bakingContext, this._modelBaker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, this);
                this.cache.put(hash, (Object)bakedModel);
                return bakedModel;
            }
            return (BakedModel)this.cache.get(hash);
        }
    }

    public static class Loader
    implements IGeometryLoader<FoilItemModel> {
        @NotNull
        public FoilItemModel read(JsonObject jsonObject, @NotNull JsonDeserializationContext deserializationContext) {
            ResourceLocation fluidName;
            Optional fluid;
            FluidStack stack = FluidStack.EMPTY;
            if (jsonObject.has("fluid") && (fluid = BuiltInRegistries.FLUID.getOptional(fluidName = ResourceLocation.parse((String)jsonObject.get("fluid").getAsString()))).isPresent()) {
                stack = new FluidStack((Fluid)fluid.get(), 1000);
            }
            return new FoilItemModel(stack);
        }
    }
}

