/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.jei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.compat.viewers.jei.FabricatorTransferHandler;
import tv.soaryn.xycraft.machines.compat.viewers.jei.GhostSlotHandler;
import tv.soaryn.xycraft.machines.compat.viewers.jei.categories.ExtractorCategory;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation _id = XyMachines.resource("jei");

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        super.onRuntimeAvailable(jeiRuntime);
        ArrayList<FluidStack> list = new ArrayList<FluidStack>();
        list.add(new FluidStack((Holder)MachinesContent.Fluid.OreSlurry.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.RedstoneSlurry.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.Nitrogen.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.Steam.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.Resin.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.SulfuricAcid.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.LiquidNitrogen.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.LiquidDye.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.Batter.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.Coolant.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.CrudeOil.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.CryoCoolant.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.HeavyOilResidue.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.SaltWater.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.ShakenMilk.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.SuperHeatedOre.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.Fuel.Source, 1000));
        list.add(new FluidStack((Holder)MachinesContent.Fluid.BioFuel.Source, 1000));
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return _id;
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtractorCategory(guiHelper)});
    }

    public void registerIngredients(@NotNull IModIngredientRegistration registration) {
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new FabricatorTransferHandler(), RecipeTypes.CRAFTING);
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        super.registerRecipes(registration);
        ExtractorCategory.register(registration);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(BaseMenuUI.class, new GhostSlotHandler());
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        super.registerRecipeCatalysts(registration);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachinesContent.Block.Extractor), new RecipeType[]{ExtractorCategory.Type});
    }
}

