/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.jei.categories;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.PlayerStageAttachment;
import tv.soaryn.xycraft.core.content.recipe.ChanceOutput;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.oldwidget.ImageWidget;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.compat.viewers.jei.categories.XyCategory;
import tv.soaryn.xycraft.machines.content.recipes.producers.crusher.CrusherRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class CrusherCategory
extends XyCategory<CrusherRecipe> {
    public static final RecipeType<CrusherRecipe> Type = new RecipeType(XyMachines.resource("crusher"), CrusherRecipe.class);

    public CrusherCategory(IGuiHelper helper) {
        super("jei.xycraft.recipe.crusher", helper, Type, helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)WorldContent.Item.XychoriumGem.get(XyCraftColors.Blue))), helper.createBlankDrawable(140, 62), new Rectangle(0.0f, 0.0f, 140.0f, 62.0f));
    }

    public static void register(IRecipeRegistration registration) {
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        ArrayList list = manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MachinesRecipeTypes.Crusher.type().get()).stream().map(RecipeHolder::value).collect(Collectors.toCollection(ArrayList::new));
        registration.addRecipes(Type, (List)list);
    }

    @Override
    public void drawSlots(@NotNull CrusherRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        NineSlicedResource slotUi = new NineSlicedResource(XyCore.resource((String)"textures/gui/sliced/slot.png"));
        int left = 0;
        int top = 1;
        guiGraphics.setColor(0.6f, 0.6f, 0.6f, 0.9f);
        slotUi.render(guiGraphics.pose(), (float)(left + 23), (float)(top + 4 + 16), 18.0f, 18.0f, 1.0f);
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                slotUi.render(guiGraphics.pose(), (float)(left + 63 + c * 18), (float)(top + 3 + r * 18), 18.0f, 18.0f, 1.0f);
            }
        }
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int baseColor = -2002094268;
        int glowColor = -1429436331;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(left + 44), (float)(top + 4 + 17), 0.0f);
        new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_full.png"), 67.0f, 34.0f, 16.0f, 16.0f, -1435011209).render(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_glow.png"), 67.0f, 34.0f, 16.0f, 16.0f, -1146443094).render(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_full.png"), 103.0f, 34.0f, 16.0f, 16.0f, baseColor).render(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_glow.png"), 103.0f, 34.0f, 16.0f, 16.0f, glowColor).render(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        guiGraphics.pose().popPose();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, CrusherRecipe recipe, @NotNull IFocusGroup focuses) {
        Player player = Utils.getClientPlayer();
        if (recipe.requiredStage().isPresent() && player != null && !((PlayerStageAttachment)player.getData(CoreAttachments.PlayerStageData)).stages().getOrDefault((Object)recipe.requiredStage().get(), false)) {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(recipe.input().ingredient());
            ArrayList<ChanceOutput> results = recipe.results();
            for (int i = 0; i < results.size(); ++i) {
                ChanceOutput result = results.get(i);
                builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(result.output());
            }
            return;
        }
        int left = 0;
        int top = 1;
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 22).addIngredients(recipe.input().ingredient());
        ArrayList<ChanceOutput> results = recipe.results();
        for (int i = 0; i < results.size(); ++i) {
            int c = i % 3;
            int r = i / 3;
            ChanceOutput result = results.get(i);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, left + 64 + 18 * c, top + 4 + 18 * r).addItemStack(result.output())).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(Component.translatable((String)"jei.xycraft.recipe.crusher.tooltip", (Object[])new Object[]{result.chance()}).withStyle(ChatFormatting.GRAY)));
        }
    }
}

