/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.api.content.pipes.PipeGraph;
import tv.soaryn.xycraft.api.content.pipes.PipeNet;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.attachments.memory.CapabilityCacheAttachment;
import tv.soaryn.xycraft.core.content.attachments.memory.CapabilitySidedCacheAttachment;
import tv.soaryn.xycraft.core.content.blocks.ICapabilityCleanupBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.machines.content.blocks.pipe.IPipeWeightProvider;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeBlock;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeConnectionAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesCapabilities;

public abstract class PipeBlockEntity<T>
extends XyBlockEntity
implements ICapabilityCleanupBlockEntity,
IPipeWeightProvider {
    public static final ModelProperty<Integer> ModelPropKey = new ModelProperty();

    public PipeBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, AttachmentType<?> ... attachmentsToSync) {
        super(blockEntityType, pos, state, attachmentsToSync);
        this.needsModelRequest();
    }

    public static int makeModelKey(Function<Direction, PipeConnectionType> connectionLookup) {
        int key = 0;
        for (Direction dir : Direction.values()) {
            PipeConnectionType con = connectionLookup.apply(dir);
            if (con == null) continue;
            key |= con.ordinal() << dir.ordinal() * 2;
        }
        return key;
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.EMPTY.derive().with(ModelPropKey, (Object)PipeBlockEntity.makeModelKey(arg_0 -> ((PipeConnectionAttachment)this.getData(MachinesAttachments.Block.PipeConnectionData)).map().get(arg_0))).build();
    }

    public abstract Supplier<AttachmentType<CapabilitySidedCacheAttachment<T>>> getCapCache();

    public boolean isDirtyEstimate() {
        CapabilitySidedCacheAttachment capData = (CapabilitySidedCacheAttachment)this.getData(this.getCapCache());
        if (capData.IsDirty) {
            return true;
        }
        CapabilityCacheAttachment pipeData = (CapabilityCacheAttachment)this.getData(MachinesAttachments.Block.AdjacentPipeCapabilityCache);
        return pipeData.IsDirty;
    }

    public Set<Direction> getDirtySides() {
        CapabilitySidedCacheAttachment capData = (CapabilitySidedCacheAttachment)this.getData(this.getCapCache());
        CapabilityCacheAttachment pipeData = (CapabilityCacheAttachment)this.getData(MachinesAttachments.Block.AdjacentPipeCapabilityCache);
        return capData.DirtySides.reference2BooleanEntrySet().stream().filter(entry -> entry.getBooleanValue() || pipeData.DirtySides.getBoolean(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void setChanged() {
        super.setChanged();
    }

    public void onLoad() {
        super.onLoad();
        if (!(this.level instanceof ServerLevel)) {
            return;
        }
        for (Direction direction : Direction.values()) {
            CapAccess.general((BlockEntity)this, (Direction)direction, this.getCapCache());
            ((CapabilityCacheAttachment)this.getData(MachinesAttachments.Block.AdjacentPipeCapabilityCache)).getCap(direction);
        }
    }

    public void handleCleanup(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos pos, BlockState state, long currentStep, Set<Direction> set) {
        Block block = this.getBlockState().getBlock();
        if (!(block instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipeBlock = (PipeBlock)block;
        CapabilitySidedCacheAttachment data = (CapabilitySidedCacheAttachment)this.getData(this.getCapCache());
        CapabilityCacheAttachment lookup = (CapabilityCacheAttachment)this.getData(MachinesAttachments.Block.AdjacentPipeCapabilityCache);
        data.IsDirty = false;
        lookup.IsDirty = false;
        PipeGraph lastGraph = PipeNet.getGraph((ServerLevel)level, (BlockPos)pos, pipeBlock._pipeNetwork);
        for (Direction side : set) {
            PipeConnectionType logic;
            data.DirtySides.put((Object)side, false);
            lookup.DirtySides.put((Object)side, false);
            BlockPos otherPos = pos.relative(side);
            IPipeConnection pipeConnections = (IPipeConnection)level.getCapability(MachinesCapabilities.PipeConnection.BLOCK, pos, null);
            if (pipeConnections == null) {
                return;
            }
            IPipeConnection adjConnections = (IPipeConnection)lookup.getCap(side);
            if (!pipeConnections.canConnect(side)) {
                pipeConnections.setSide(side, PipeConnectionType.None);
                continue;
            }
            PipeGraph currentGraph = PipeNet.getGraph((ServerLevel)level, (BlockPos)otherPos, pipeBlock._pipeNetwork);
            if (currentGraph != null) {
                if (!currentGraph.canMerge(lastGraph)) continue;
                lastGraph = currentGraph;
            }
            Object otherCap = data.getCap(side);
            if (!(adjConnections == null || adjConnections.canConnect(side.getOpposite()) && pipeConnections.getHandledCap() == adjConnections.getHandledCap())) {
                logic = pipeConnections.getLogic(side);
                if (logic != PipeConnectionType.Transfer) continue;
                pipeConnections.setSide(side, PipeConnectionType.None);
                continue;
            }
            if (adjConnections == null && otherCap == null) {
                logic = pipeConnections.getLogic(side);
                if (logic != PipeConnectionType.Transfer) continue;
                pipeConnections.setSide(side, PipeConnectionType.None);
                continue;
            }
            if (adjConnections != null) {
                if (pipeConnections.getLogic(side) != PipeConnectionType.None) continue;
                pipeConnections.setSide(side, adjConnections.getLogic(side.getOpposite()) != PipeConnectionType.None ? PipeConnectionType.Transfer : PipeConnectionType.None);
                continue;
            }
            if (pipeConnections.getLogic(side) != PipeConnectionType.None) continue;
            pipeConnections.setSide(side, PipeConnectionType.Transfer);
        }
    }
}

