/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.joml.Quaternionf;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.registries.CoreItemDataComponents;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.slots.FancySlot;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableBackground;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableCanvas;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableFluid;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableFrame;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableImage;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.gui.TankMenu;

public class TankUI
extends BaseMenuUI<TankMenu> {
    private final FluidTank _tank = new FluidTank(0);

    public TankUI(TankMenu menu, Inventory playerInv, Component title) {
        super((BaseMenu)menu, playerInv, title, 200, 192);
        this._tank.setCapacity(menu.tank.getTankCapacity(0));
    }

    protected void init() {
        super.init();
        ResourceLocation glowArrowLoc = XyMachines.resource("textures/gui/icons/arrow_glow.png");
        ResourceLocation arrowFullLoc = XyMachines.resource("textures/gui/icons/arrow_full.png");
        ResourceLocation liquidLoc = XyMachines.resource("textures/gui/icons/liquid.png");
        ResourceLocation bucketLoc = XyMachines.resource("textures/gui/icons/bucket.png");
        NineSlicedResource tankLoc = new NineSlicedResource(XyCore.resource((String)"textures/gui/sliced/tank_new.png"));
        NineSlicedResource thinBorder = new NineSlicedResource(XyCore.resource((String)"textures/gui/sliced/border_thin.png"));
        int inputColorGlow = 1720237055;
        int inputColorBase = -869046597;
        int outputColorGlow = 1728031266;
        int outputColorBase = -861247966;
        int genericColorGlow = -1717723753;
        int genericColorBase = -582529198;
        FancySlot[] slotGroup = (FancySlot[])((TankMenu)this.menu).slots.stream().filter(FancySlot.class::isInstance).toArray(FancySlot[]::new);
        int offset = 15;
        ((DrawableCanvas)this.rootCanvas.addChild(DrawableFrame::create, frame -> ((DrawableFrame)((DrawableFrame)((DrawableFrame)((DrawableFrame)((DrawableFrame)((DrawableFrame)((DrawableFrame)frame.dimensions(0.0f, -8.0f, 1.0f, 100.0f).fillParentHorizontal()).scale(0.85f, 1.0f)).addChild(DrawableBackground::create, BaseMenuUI::backgroundFillWithPlayerColor)).addChild(DrawableFrame::create, tankWindow -> ((DrawableFrame)tankWindow.texture(thinBorder).dimensions((float)(70 - offset), 10.0f, 60.0f, 80.0f).addChild(DrawableBackground::create, bgrnd -> ((DrawableBackground)bgrnd.fillParent()).color(genericColorGlow))).addChild(DrawableFrame::create, tankFrame -> ((DrawableFrame)((DrawableFrame)((DrawableFrame)((DrawableFrame)tankFrame.texture(tankLoc).fillParent()).onPreDraw((widget, graphics, x, y, mouseX, mouseY, depth) -> graphics.fill((int)x, (int)y, (int)(x + widget.Dimensions.x + widget.Dimensions.width), (int)(y + widget.Dimensions.y + widget.Dimensions.height), -12369085))).move(tankWindow.Padding.x + 3.0f, tankWindow.Padding.y + 3.0f)).offsetSize(tankWindow.Padding.width - 10.0f, tankWindow.Padding.height - 10.0f)).paddingOverride(1.0f, 1.0f, -1.0f, -1.0f).addChild(DrawableFluid::create, fluid -> ((DrawableFluid)((DrawableFluid)((DrawableFluid)fluid.fillParent()).move(tankFrame.Padding.x, tankFrame.Padding.y)).offsetSize(tankFrame.Padding.width, tankFrame.Padding.height)).tank((IFluidHandler)this._tank, 0))))).addChild(DrawableImage::create, arrow -> TankUI.handleArrow(arrow, 57 - offset, 26, glowArrowLoc, arrowFullLoc, inputColorGlow, inputColorBase, false))).addChild(DrawableImage::create, arrow -> TankUI.handleArrow(arrow, 131 - offset, 26, glowArrowLoc, arrowFullLoc, outputColorGlow, outputColorBase, false))).addChild(DrawableImage::create, arrow -> TankUI.handleArrow(arrow, 40 - offset, 44, glowArrowLoc, arrowFullLoc, genericColorGlow, genericColorBase, true))).addChild(DrawableImage::create, arrow -> TankUI.handleArrow(arrow, 148 - offset, 44, glowArrowLoc, arrowFullLoc, genericColorGlow, genericColorBase, true)))).addChild(DrawableFrame::create, arg_0 -> ((TankUI)this).defaultPlayerPanel(arg_0));
        this.updateTank();
    }

    private static void rotate90(DrawableImage widget, GuiGraphics graphics, double x, double y, double mouseX, double mouseY, int depth) {
        PoseStack poseStack = graphics.pose();
        double xOffset = (double)(widget.Dimensions.x + widget.Dimensions.width / 2.0f) + x;
        double yOffset = (double)(widget.Dimensions.y + widget.Dimensions.height / 2.0f) + y;
        poseStack.translate(xOffset, yOffset, 0.0);
        poseStack.mulPose(new Quaternionf().rotationZ(1.5707964f));
        poseStack.translate(-xOffset, -yOffset, 0.0);
    }

    private static void handleArrow(DrawableImage arrow, int x, int y, ResourceLocation glowArrowLoc, ResourceLocation arrowFullLoc, int inputColorGlow, int inputColorBase, boolean isRotated) {
        ((DrawableImage)((DrawableImage)arrow.dimensions((float)x, (float)y, 12.0f, 12.0f)).color(inputColorGlow)).texture(glowArrowLoc).addChild(DrawableImage::create, subArrow -> ((DrawableImage)((DrawableImage)subArrow.fillParent()).color(inputColorBase)).texture(arrowFullLoc));
        if (isRotated) {
            arrow.onPreDraw(TankUI::rotate90);
        }
    }

    protected void containerTick() {
        super.containerTick();
        this.updateTank();
    }

    private void updateTank() {
        this._tank.setFluid(((SimpleFluidContent)((TankMenu)this.menu).tankContainer.get(0).getOrDefault((Supplier)CoreItemDataComponents.FluidContainer, (Object)SimpleFluidContent.EMPTY)).copy());
    }
}

